/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.KonigException;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeConsumer;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlTargetNodeShapeFactory;
import io.konig.core.showl.ShowlTransformService;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlTransformEngine {
    private static final Logger logger = LoggerFactory.getLogger(ShowlTransformEngine.class);
    private ShowlTargetNodeShapeFactory targetNodeShapeFactory;
    private ShapeManager shapeManager;
    private ShowlTransformService transformService;
    private ShowlNodeShapeConsumer consumer;
    private boolean failFast;
    private boolean encounteredErrors;

    public ShowlTransformEngine(ShowlTargetNodeShapeFactory targetNodeShapeFactory, ShapeManager shapeManager, ShowlTransformService transformService, ShowlNodeShapeConsumer consumer) {
        this.targetNodeShapeFactory = targetNodeShapeFactory;
        this.shapeManager = shapeManager;
        this.transformService = transformService;
        this.consumer = consumer;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public boolean isEncounteredErrors() {
        return this.encounteredErrors;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void run() {
        for (Shape shape : this.shapeManager.listShapes()) {
            List<ShowlNodeShape> targetNodeList = this.targetNodeShapeFactory.createTargetNodeShapes(shape);
            for (ShowlNodeShape targetNode : targetNodeList) {
                try {
                    Set<ShowlPropertyShapeGroup> unmapped = this.transformService.computeTransform(targetNode);
                    if (unmapped.isEmpty()) {
                        if (this.consumer == null) continue;
                        this.consumer.consume(targetNode);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append("run: Failed to compute transform for ");
                    builder.append(RdfUtil.localName(shape.getId()));
                    builder.append(".  The following properties were not mapped:\n");
                    for (ShowlPropertyShapeGroup group : unmapped) {
                        builder.append("   ");
                        builder.append(group.pathString());
                        builder.append("\n");
                    }
                    logger.warn(builder.toString());
                }
                catch (Throwable oops) {
                    String msg = "Failed to compute transform for " + targetNode.getPath();
                    if (this.failFast) {
                        throw new KonigException(msg);
                    }
                    logger.error(msg, oops);
                }
            }
        }
    }
}

