/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlFormulaPropertyShape;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.formula.DirectionStep;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;

public class ShowlTraverser {
    private ShowlManager manager;
    private Map<URI, ShowlClass> classMap = new HashMap<URI, ShowlClass>();

    public ShowlTraverser(ShowlManager manager) {
        this.manager = manager;
    }

    public ShowlManager getManager() {
        return this.manager;
    }

    public ShowlPropertyShape findPropertyByLocalName(URI owlClassId, String propertyLocalName) {
        ShowlClass owlClass = this.owlClass(owlClassId);
        for (ShowlNodeShape node : owlClass.getTargetClassOf()) {
            for (ShowlPropertyShape p : node.allOutwardProperties()) {
                if (!p.getPredicate().getLocalName().equals(propertyLocalName)) continue;
                return p;
            }
        }
        if (this.manager.getReasoner().isEnumerationClass((Resource)owlClassId)) {
            List<Vertex> list = this.manager.getReasoner().getGraph().v((Resource)owlClassId).in(RDF.TYPE).toVertexList();
            for (Vertex v : list) {
                for (Edge e : v.outEdgeSet()) {
                    if (!e.getPredicate().getLocalName().equals(propertyLocalName)) continue;
                    PropertyConstraint constraint = new PropertyConstraint(e.getPredicate());
                    if (e.getObject() instanceof Literal) {
                        Literal literal = (Literal)e.getObject();
                        constraint.setDatatype(literal.getDatatype());
                    }
                    ShowlProperty property = this.manager.produceShowlProperty(e.getPredicate());
                    ShowlDirectPropertyShape p = new ShowlDirectPropertyShape(null, null, constraint);
                    p.setProperty(property);
                    return p;
                }
            }
        }
        return null;
    }

    public ShowlClass owlClass(URI owlClassId) {
        ShowlClass owlClass = this.classMap.get(owlClassId);
        if (owlClass == null) {
            owlClass = this.manager.produceOwlClass(owlClassId);
            this.classMap.put(owlClassId, owlClass);
            for (Shape shape : this.manager.getShapeManager().getShapesByTargetClass(owlClassId)) {
                ShowlNodeShape node = new ShowlNodeShape(this.manager, null, shape, owlClass);
                owlClass.addTargetClassOf(node);
                this.manager.addIdProperty(node);
                this.manager.addProperties(node);
            }
        }
        return owlClass;
    }

    public Set<URI> valueClass(URI targetClass, QuantifiedExpression formula) {
        ShowlClass owlClass = this.owlClass(targetClass);
        PrimaryExpression primary = formula.asPrimaryExpression();
        if (primary instanceof PathExpression) {
            PathExpression path = (PathExpression)primary;
            Set<ShowlProperty> propertySet = null;
            for (PathStep step : path.getStepList()) {
                if (!(step instanceof DirectionStep)) continue;
                DirectionStep dirStep = (DirectionStep)step;
                switch (dirStep.getDirection()) {
                    case OUT: {
                        URI predicate = dirStep.getIri();
                        propertySet = propertySet == null ? this.out(owlClass, predicate) : this.out(propertySet, predicate);
                        break;
                    }
                    case IN: {
                        throw new RuntimeException("In steps not supported yet");
                    }
                }
            }
            HashSet<URI> result = new HashSet<URI>();
            for (ShowlProperty p : propertySet) {
                if (p.getRange() != null) {
                    result.add(p.getRange().getId());
                    continue;
                }
                result.addAll(p.rangeIncludes(this.manager.getReasoner()));
            }
            return result;
        }
        return null;
    }

    public Set<ShowlProperty> traverse(URI variable, URI owlClass, QuantifiedExpression formula) {
        PrimaryExpression primary = formula.asPrimaryExpression();
        if (primary instanceof PathExpression) {
            return this.traversePath(variable, owlClass, (PathExpression)primary);
        }
        return Collections.emptySet();
    }

    private Set<ShowlProperty> traversePath(URI variable, URI owlClassId, PathExpression path) {
        if (variable != null && owlClassId != null && path != null) {
            ShowlClass owlClass = this.owlClass(owlClassId);
            Set<ShowlProperty> propertySet = null;
            for (PathStep step : path.getStepList()) {
                if (!(step instanceof DirectionStep)) continue;
                DirectionStep dirStep = (DirectionStep)step;
                URI predicate = dirStep.getTerm().getIri();
                switch (dirStep.getDirection()) {
                    case OUT: {
                        propertySet = propertySet == null ? this.out(owlClass, predicate) : this.out(propertySet, predicate);
                        break;
                    }
                    case IN: {
                        throw new RuntimeException("In steps not supported yet");
                    }
                }
            }
            return propertySet == null ? Collections.emptySet() : propertySet;
        }
        return Collections.emptySet();
    }

    public Set<ShowlProperty> out(Set<ShowlProperty> propertySet, URI outPredicate) {
        HashSet<URI> memory = new HashSet<URI>();
        HashSet<ShowlClass> classes = new HashSet<ShowlClass>();
        for (ShowlProperty p : propertySet) {
            this.addRangeIncludes(memory, classes, p);
        }
        HashSet<ShowlProperty> result = new HashSet<ShowlProperty>();
        for (ShowlClass owlClass : classes) {
            Set<ShowlProperty> p = this.out(owlClass, outPredicate);
            result.addAll(p);
        }
        return result;
    }

    public Set<ShowlProperty> out(Set<ShowlProperty> propertySet, String localName) {
        HashSet<URI> memory = new HashSet<URI>();
        HashSet<ShowlClass> classes = new HashSet<ShowlClass>();
        for (ShowlProperty p : propertySet) {
            this.addRangeIncludes(memory, classes, p);
        }
        HashSet<ShowlProperty> result = new HashSet<ShowlProperty>();
        for (ShowlClass owlClass : classes) {
            Set<ShowlProperty> p = this.out(owlClass, localName);
            result.addAll(p);
        }
        return result;
    }

    private void addRangeIncludes(Set<URI> memory, Set<ShowlClass> classes, ShowlProperty p) {
        URI predicate = p.getPredicate();
        if (!memory.contains(predicate)) {
            memory.add(predicate);
            ShowlClass range = p.getRange();
            if (range != null) {
                classes.add(range);
            } else {
                for (URI owlClassId : p.rangeIncludes(this.manager.getReasoner())) {
                    classes.add(this.owlClass(owlClassId));
                }
            }
        }
    }

    public Set<ShowlProperty> out(ShowlClass owlClass, URI outPredicate) {
        ShowlPropertyShape ps;
        ShowlProperty property;
        URI predicate;
        Shape shape;
        HashSet<ShowlProperty> result = new HashSet<ShowlProperty>();
        for (ShowlProperty p : owlClass.getDomainOf()) {
            if (!p.getPredicate().equals((Object)outPredicate)) continue;
            result.add(p);
        }
        if (!result.isEmpty()) {
            return result;
        }
        for (ShowlNodeShape node : owlClass.getTargetClassOf()) {
            shape = node.getShape();
            for (PropertyConstraint p : shape.getProperty()) {
                predicate = p.getPredicate();
                if (predicate == null || !predicate.equals((Object)outPredicate)) continue;
                property = this.produceProperty(predicate, owlClass);
                result.add(property);
                ps = new ShowlDirectPropertyShape(node, property, p);
                property.addPropertyShape(ps);
                node.addProperty((ShowlDirectPropertyShape)ps);
            }
        }
        for (ShowlNodeShape node : owlClass.getTargetClassOf()) {
            shape = node.getShape();
            for (PropertyConstraint p : shape.getDerivedProperty()) {
                predicate = p.getPredicate();
                if (predicate == null) continue;
                property = this.produceProperty(predicate, owlClass);
                result.add(property);
                ps = new ShowlFormulaPropertyShape(node, property, p);
                node.addDerivedProperty((ShowlDerivedPropertyShape)ps);
            }
        }
        if (result.isEmpty()) {
            ShowlProperty property2 = this.produceProperty(outPredicate, owlClass);
            result.add(property2);
        }
        return result;
    }

    public Set<ShowlProperty> out(ShowlClass owlClass, String localName) {
        ShowlPropertyShape ps;
        ShowlProperty property;
        URI predicate;
        Shape shape;
        HashSet<ShowlProperty> result = new HashSet<ShowlProperty>();
        for (ShowlProperty p : owlClass.getDomainOf()) {
            if (!p.getPredicate().getLocalName().equals(localName)) continue;
            result.add(p);
        }
        if (!result.isEmpty()) {
            return result;
        }
        for (ShowlNodeShape node : owlClass.getTargetClassOf()) {
            shape = node.getShape();
            for (PropertyConstraint p : shape.getProperty()) {
                predicate = p.getPredicate();
                if (predicate == null || !predicate.getLocalName().equals(localName)) continue;
                property = this.produceProperty(predicate, owlClass);
                result.add(property);
                ps = new ShowlDirectPropertyShape(node, property, p);
                property.addPropertyShape(ps);
                node.addProperty((ShowlDirectPropertyShape)ps);
            }
        }
        for (ShowlNodeShape node : owlClass.getTargetClassOf()) {
            shape = node.getShape();
            for (PropertyConstraint p : shape.getDerivedProperty()) {
                predicate = p.getPredicate();
                if (predicate == null) continue;
                property = this.produceProperty(predicate, owlClass);
                result.add(property);
                ps = new ShowlFormulaPropertyShape(node, property, p);
                node.addDerivedProperty((ShowlDerivedPropertyShape)ps);
            }
        }
        if (result.isEmpty()) {
            OwlReasoner owlReasoner = this.manager.getReasoner();
            Graph graph = owlReasoner.getGraph();
            Set<URI> terms = graph.lookupLocalName(localName);
            for (URI term : terms) {
                if (!owlReasoner.isProperty(term)) continue;
                ShowlProperty property2 = this.produceProperty(term, owlClass);
                result.add(property2);
            }
        }
        return result;
    }

    private ShowlProperty produceProperty(URI term, ShowlClass owlClass) {
        ShowlProperty p = this.manager.produceShowlProperty(term);
        owlClass.addDomainOf(p);
        return p;
    }
}

