/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.SynsetProperty;
import io.konig.core.showl.UniqueKeyElement;
import java.util.ArrayList;
import java.util.List;

public class ShowlUniqueKey
extends ArrayList<UniqueKeyElement>
implements Comparable<ShowlUniqueKey> {
    public ShowlUniqueKey() {
    }

    public ShowlUniqueKey(UniqueKeyElement ... e) {
        for (UniqueKeyElement element : e) {
            this.add(element);
        }
    }

    public List<UniqueKeyElement> flatten() throws ShowlProcessingException {
        ArrayList<UniqueKeyElement> list = new ArrayList<UniqueKeyElement>();
        this.addAllElements(list, this);
        return list;
    }

    private void addAllElements(List<UniqueKeyElement> list, ShowlUniqueKey key) throws ShowlProcessingException {
        for (UniqueKeyElement element : key) {
            this.addElement(list, element);
        }
    }

    private void addElement(List<UniqueKeyElement> list, UniqueKeyElement element) throws ShowlProcessingException {
        if (element.getValueKeys() == null) {
            list.add(element);
        } else {
            ShowlUniqueKey key = element.getSelectedKey();
            if (key == null) {
                throw new ShowlProcessingException("Selected key not defined for " + element.getPropertyShape().getPath());
            }
            this.addAllElements(list, key);
        }
    }

    @Override
    public int compareTo(ShowlUniqueKey other) {
        int result = this.size() - other.size();
        if (result == 0) {
            for (int i = 0; result == 0 && i < this.size(); ++i) {
                ShowlPropertyShape a = ((UniqueKeyElement)this.get(i)).getPropertyShape();
                ShowlPropertyShape b = ((UniqueKeyElement)other.get(i)).getPropertyShape();
                result = a.getPredicate().getLocalName().compareTo(b.getPredicate().getLocalName());
            }
        }
        return result;
    }

    public boolean matches(ShowlUniqueKey other) {
        if (other.size() == this.size()) {
            for (int i = 0; i < this.size(); ++i) {
                UniqueKeyElement thisElement = (UniqueKeyElement)this.get(i);
                UniqueKeyElement otherElement = (UniqueKeyElement)other.get(i);
                SynsetProperty thisSynset = thisElement.getPropertyShape().asSynsetProperty();
                SynsetProperty otherSynset = otherElement.getPropertyShape().asSynsetProperty();
                if (thisSynset.getPredicates().contains(otherElement.getPropertyShape().getPredicate()) || otherSynset.getPredicates().contains(thisElement.getPropertyShape().getPredicate())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasRepeatedField() {
        for (UniqueKeyElement element : this) {
            if (!element.getPropertyShape().isRepeated()) continue;
            return true;
        }
        return false;
    }
}

