/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlUniqueKey;
import io.konig.core.showl.UniqueKeyElement;
import java.util.ArrayList;
import java.util.List;

public class ShowlUniqueKeyCollection
extends ArrayList<ShowlUniqueKey> {
    private ShowlNodeShape nodeShape;

    public ShowlUniqueKeyCollection(ShowlNodeShape nodeShape) {
        this.nodeShape = nodeShape;
    }

    public ShowlNodeShape getNodeShape() {
        return this.nodeShape;
    }

    public List<ShowlPropertyShape> flatten() {
        if (this.canFlatten()) {
            ArrayList<ShowlPropertyShape> list = new ArrayList<ShowlPropertyShape>();
            this.addProperties(list, this);
            return list;
        }
        return null;
    }

    public ShowlUniqueKey findMatch(ShowlUniqueKey pattern) {
        for (ShowlUniqueKey key : this) {
            if (!key.matches(pattern)) continue;
            return key;
        }
        return null;
    }

    private void addProperties(List<ShowlPropertyShape> list, ShowlUniqueKeyCollection c) {
        for (ShowlUniqueKey key : c) {
            for (UniqueKeyElement e : key) {
                ShowlUniqueKeyCollection k = e.getValueKeys();
                if (k != null) {
                    this.addProperties(list, k);
                    continue;
                }
                list.add(e.getPropertyShape());
            }
        }
    }

    private boolean canFlatten() {
        if (this.size() == 1) {
            for (ShowlUniqueKey key : this) {
                for (UniqueKeyElement e : key) {
                    ShowlUniqueKeyCollection c = e.getValueKeys();
                    if (c == null || c.canFlatten()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

