/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEnumIndividualReference;
import io.konig.core.showl.ShowlEnumNodeExpression;
import io.konig.core.showl.ShowlEnumPropertyExpression;
import io.konig.core.showl.ShowlEnumStructExpression;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlOverlayExpression;
import io.konig.core.showl.ShowlPredicatePath;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import io.konig.core.vocab.Konig;
import io.konig.formula.KqlType;
import io.konig.shacl.PropertyConstraint;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShowlUtil {
    public static final String ENUM_SHAPE_BASE_IRI = "urn:konig:enumShape/";

    public static boolean isUndefinedClass(ShowlClass owlClass) {
        return owlClass == null || Konig.Undefined.equals((Object)owlClass.getId());
    }

    public static KqlType kqlType(URI rdfType) {
        if (XMLSchema.INT.equals((Object)rdfType) || XMLSchema.INTEGER.equals((Object)rdfType) || XMLSchema.LONG.equals((Object)rdfType) || XMLSchema.SHORT.equals((Object)rdfType) || XMLSchema.BYTE.equals((Object)rdfType) || XMLSchema.NON_POSITIVE_INTEGER.equals((Object)rdfType) || XMLSchema.NON_NEGATIVE_INTEGER.equals((Object)rdfType) || XMLSchema.NEGATIVE_INTEGER.equals((Object)rdfType) || XMLSchema.UNSIGNED_BYTE.equals((Object)rdfType) || XMLSchema.UNSIGNED_BYTE.equals((Object)rdfType) || XMLSchema.UNSIGNED_LONG.equals((Object)rdfType) || XMLSchema.UNSIGNED_SHORT.equals((Object)rdfType) || XMLSchema.UNSIGNED_BYTE.equals((Object)rdfType)) {
            return KqlType.INTEGER;
        }
        if (XMLSchema.DECIMAL.equals((Object)rdfType) || XMLSchema.FLOAT.equals((Object)rdfType) || XMLSchema.DOUBLE.equals((Object)rdfType)) {
            return KqlType.NUMBER;
        }
        if (XMLSchema.DATETIME.equals((Object)rdfType) || XMLSchema.DATE.equals((Object)rdfType) || XMLSchema.GYEAR.equals((Object)rdfType) || XMLSchema.GYEARMONTH.equals((Object)rdfType)) {
            return KqlType.INSTANT;
        }
        if (XMLSchema.BASE64BINARY.equals((Object)rdfType) || XMLSchema.HEXBINARY.equals((Object)rdfType) || XMLSchema.ANYURI.equals((Object)rdfType) || XMLSchema.NOTATION.equals((Object)rdfType) || XMLSchema.STRING.equals((Object)rdfType) || XMLSchema.NORMALIZEDSTRING.equals((Object)rdfType) || XMLSchema.TOKEN.equals((Object)rdfType) || XMLSchema.LANGUAGE.equals((Object)rdfType) || XMLSchema.NAME.equals((Object)rdfType) || XMLSchema.NMTOKEN.equals((Object)rdfType) || XMLSchema.NCNAME.equals((Object)rdfType) || XMLSchema.NMTOKENS.equals((Object)rdfType) || XMLSchema.ID.equals((Object)rdfType) || XMLSchema.IDREF.equals((Object)rdfType) || XMLSchema.ENTITY.equals((Object)rdfType) || XMLSchema.QNAME.equals((Object)rdfType)) {
            return KqlType.STRING;
        }
        return null;
    }

    public static boolean isWellDefined(ShowlPropertyShape p) {
        if (p.isDirect() && p.getValueShape() == null) {
            return true;
        }
        ShowlPropertyShape synonym = p.getSynonym();
        if (synonym != null && synonym.isDirect() && synonym.getValueShape() == null) {
            return true;
        }
        return ShowlUtil.isWellDefined(p.getFormula()) || ShowlUtil.isWellDefined(p.getSelectedExpression());
    }

    public static boolean isWellDefined(ShowlExpression e) {
        if (e == null) {
            return false;
        }
        for (ShowlPropertyShape p : ShowlExpression.parameters(e)) {
            if (ShowlUtil.isWellDefined(p)) continue;
            return false;
        }
        return true;
    }

    public static List<URI> relativePath(ShowlNodeShape a, ShowlNodeShape b) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (a == b) {
            return result;
        }
        ShowlPropertyShape p = a.getAccessor();
        while (p != null) {
            result.add(p.getPredicate());
            a = p.getDeclaringShape();
            if (a == b) {
                Collections.reverse(result);
                return result;
            }
            p = a.getAccessor();
        }
        return null;
    }

    public static boolean isWellDefined(ShowlNodeShape node) {
        for (ShowlDirectPropertyShape direct : node.getProperties()) {
            if (!(direct.getValueShape() != null ? !ShowlUtil.isWellDefined(direct.getValueShape()) : !ShowlUtil.isWellDefined(direct))) continue;
            return false;
        }
        return true;
    }

    public static ShowlPropertyExpression propertyExpression(ShowlPropertyShape p) {
        return p instanceof ShowlDirectPropertyShape ? new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)p) : new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)p);
    }

    public static ShowlChannel channelFor(ShowlNodeShape enumNode, List<ShowlChannel> channelList) {
        for (ShowlChannel channel : channelList) {
            if (channel.getSourceNode() != enumNode) continue;
            return channel;
        }
        return null;
    }

    public static ShowlPropertyShape otherProperty(ShowlEqualStatement equal, ShowlNodeShape node) {
        ShowlPropertyShape left = ShowlUtil.propertyShape(equal.getLeft());
        ShowlPropertyShape right = ShowlUtil.propertyShape(equal.getRight());
        if (left != null && left.getDeclaringShape() == node) {
            return right;
        }
        if (right != null && right.getDeclaringShape() != node) {
            return left;
        }
        return null;
    }

    public static ShowlPropertyShape propertyOf(ShowlEqualStatement equal, ShowlNodeShape node) {
        ShowlPropertyShape left = ShowlUtil.propertyShape(equal.getLeft());
        if (left != null && left.getDeclaringShape() == node) {
            return left;
        }
        ShowlPropertyShape right = ShowlUtil.propertyShape(equal.getRight());
        if (right != null && right.getDeclaringShape() != node) {
            return right;
        }
        return null;
    }

    private static ShowlPropertyShape propertyShape(ShowlExpression e) {
        if (e instanceof ShowlPropertyExpression) {
            return ((ShowlPropertyExpression)e).getSourceProperty();
        }
        return null;
    }

    public static ShowlPropertyShape propertyOf(ShowlExpression e, ShowlNodeShape node) {
        ShowlPropertyShape p;
        if (e instanceof ShowlPropertyExpression && (p = ((ShowlPropertyExpression)e).getSourceProperty()).getDeclaringShape() == node) {
            return p;
        }
        return null;
    }

    public static ShowlDirectPropertyShape propertyMappedTo(ShowlNodeShape targetNode, ShowlPropertyShape sourceProperty) {
        for (ShowlDirectPropertyShape direct : targetNode.getProperties()) {
            ShowlExpression e = direct.getSelectedExpression();
            ShowlPropertyShape p = ShowlUtil.propertyShape(e);
            if (p != sourceProperty) continue;
            return direct;
        }
        return null;
    }

    public static ShowlPropertyShape asPropertyShape(ShowlExpression e) {
        if (e instanceof ShowlPropertyExpression) {
            ShowlPropertyExpression p = (ShowlPropertyExpression)e;
            return p.getSourceProperty();
        }
        return null;
    }

    public static boolean isEnumSourceNode(ShowlNodeShape sourceNode, OwlReasoner reasoner) {
        return !sourceNode.isTargetNode() && reasoner.isEnumerationClass((Resource)sourceNode.getOwlClass().getId());
    }

    public static String shortShapeName(URI shapeId) {
        String localName = shapeId.getLocalName();
        if (localName.endsWith("_Shape")) {
            return localName.substring(0, localName.length() - 6);
        }
        if (localName.endsWith("Shape")) {
            return localName.substring(0, localName.length() - 5);
        }
        return localName;
    }

    public static String shortShapeName(ShowlNodeShape node) {
        if (node == null) {
            System.err.println("Null value detected");
        }
        return ShowlUtil.shortShapeName(RdfUtil.uri((Value)node.getId()));
    }

    public static ShowlExpression enumExpression(ShowlEqualStatement equal) {
        ShowlExpression left = equal.getLeft();
        if (ShowlUtil.isEnumExpression(left)) {
            return left;
        }
        ShowlExpression right = equal.getRight();
        if (ShowlUtil.isEnumExpression(right)) {
            return right;
        }
        return null;
    }

    private static boolean isEnumExpression(ShowlExpression e) {
        return e instanceof ShowlEnumPropertyExpression || e instanceof ShowlEnumIndividualReference;
    }

    public static Set<ShowlPredicatePath> uniqueKeys(URI enumClass, ShowlNodeShape targetShape) {
        HashSet<ShowlPropertyShape> properties = new HashSet<ShowlPropertyShape>();
        for (ShowlChannel channel : targetShape.getChannels()) {
            ShowlStatement statement = channel.getJoinStatement();
            if (statement == null) continue;
            statement.addProperties(properties);
        }
        Iterator sequence = properties.iterator();
        while (sequence.hasNext()) {
            ShowlPropertyShape p = (ShowlPropertyShape)sequence.next();
            ShowlNodeShape node = p.getDeclaringShape();
            if (node.getOwlClass().getId().equals((Object)enumClass) && !Konig.id.equals((Object)p.getPredicate())) continue;
            sequence.remove();
        }
        HashSet<ShowlPredicatePath> result = new HashSet<ShowlPredicatePath>();
        for (ShowlPropertyShape p : properties) {
            result.add(ShowlPredicatePath.forProperty(p));
        }
        return result;
    }

    public static boolean isEnumNode(ShowlExpression e) {
        return e instanceof ShowlEnumNodeExpression || e instanceof ShowlEnumStructExpression;
    }

    public static ShowlNodeShape parentEnumNode(ShowlPropertyShape p) {
        while (p != null) {
            ShowlNodeShape node = p.getDeclaringShape();
            if (RdfUtil.uri((Value)node.getId()).getNamespace().startsWith(ENUM_SHAPE_BASE_IRI)) {
                return node;
            }
            p = node.getAccessor();
        }
        return null;
    }

    public static boolean isEnumProperty(ShowlPropertyShape p) {
        while (p != null) {
            ShowlNodeShape node = p.getDeclaringShape();
            if (RdfUtil.uri((Value)node.getId()).getNamespace().startsWith(ENUM_SHAPE_BASE_IRI)) {
                return true;
            }
            p = node.getAccessor();
        }
        return false;
    }

    public static boolean isEnumField(ShowlExpression e) {
        return e instanceof ShowlEnumPropertyExpression;
    }

    public static boolean isEnumNode(ShowlNodeShape node) {
        return node.getShape().getId().stringValue().startsWith(ENUM_SHAPE_BASE_IRI);
    }

    public static ShowlNodeShape containingEnumNode(ShowlPropertyShape p, OwlReasoner owlReasoner) {
        while (p != null) {
            ShowlNodeShape node = p.getDeclaringShape();
            if (owlReasoner.isEnumerationClass((Resource)node.getOwlClass().getId())) {
                return node;
            }
            p = node.getAccessor();
        }
        return null;
    }

    public static boolean isUniqueKey(ShowlPropertyShape p, OwlReasoner reasoner) {
        URI stereotype;
        if (Konig.id.equals((Object)p.getPredicate())) {
            return true;
        }
        PropertyConstraint constraint = p.getPropertyConstraint();
        if (constraint != null && (Konig.uniqueKey.equals((Object)(stereotype = constraint.getStereotype())) || Konig.primaryKey.equals((Object)stereotype))) {
            return true;
        }
        return reasoner.isInverseFunctionalProperty(p.getPredicate());
    }

    public static List<ShowlExpression> transform(List<ShowlExpression> memberList) {
        ArrayList<ShowlExpression> result = new ArrayList<ShowlExpression>();
        for (ShowlExpression e : memberList) {
            result.add(e.transform());
        }
        return result;
    }

    public static ShowlExpression transform(ShowlExpression e) {
        return e == null ? null : e.transform();
    }

    public static ShowlNodeShape parentEnumNode(ShowlPropertyShape p, OwlReasoner reasoner) {
        ShowlNodeShape result = ShowlUtil.parentEnumNode(p);
        if (result == null) {
            while (p != null) {
                ShowlNodeShape node = p.getDeclaringShape();
                URI owlClass = node.getOwlClass().getId();
                if (reasoner.isEnumerationClass((Resource)owlClass)) {
                    return node;
                }
                p = node.getAccessor();
            }
        }
        return result;
    }

    public static ShowlNodeShape enumClassNode(ShowlNodeShape enumNode) throws ShowlProcessingException {
        ShowlPropertyShape accessor = enumNode.getAccessor();
        if (accessor != null) {
            ShowlExpression s = accessor.getSelectedExpression();
            if (s instanceof ShowlEnumNodeExpression) {
                ShowlEnumNodeExpression e = (ShowlEnumNodeExpression)s;
                return e.getEnumNode();
            }
            if (s instanceof ShowlOverlayExpression) {
                ShowlOverlayExpression overlay = (ShowlOverlayExpression)s;
                ShowlNodeShape result = null;
                for (ShowlExpression e : overlay) {
                    if (e instanceof ShowlEnumNodeExpression) {
                        ShowlNodeShape n = ((ShowlEnumNodeExpression)e).getEnumNode();
                        if (result == null) {
                            result = n;
                            continue;
                        }
                        if (n == result) continue;
                        String msg = MessageFormat.format("Conflicting enum nodes in overlay expression of {0}", enumNode.getPath());
                        throw new ShowlProcessingException(msg);
                    }
                    String msg = MessageFormat.format("Expected ShowlEnumNodeExpression in overlay for {0} but found {1}", enumNode.getPath(), e.getClass().getSimpleName());
                    throw new ShowlProcessingException(msg);
                }
                return result;
            }
        }
        return null;
    }
}

