/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlDerivedPropertyList;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.SynsetProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynsetNode {
    public static Logger logger = LoggerFactory.getLogger(SynsetNode.class);
    private List<SynsetProperty> propertyList = new ArrayList<SynsetProperty>();
    private Map<URI, SynsetProperty> propertyMap = new HashMap<URI, SynsetProperty>();

    public SynsetNode(ShowlNodeShape node) {
        HashMap<ShowlPropertyShape, SynsetProperty> map = new HashMap<ShowlPropertyShape, SynsetProperty>();
        this.addProperties(map, this, node);
    }

    private SynsetNode() {
    }

    private void addProperties(Map<ShowlPropertyShape, SynsetProperty> map, SynsetNode synsetNode, ShowlNodeShape node) {
        this.addProperties(map, synsetNode, node.getProperties());
        for (ShowlDerivedPropertyList derived : node.getDerivedProperties()) {
            this.addProperties(map, synsetNode, derived);
        }
    }

    private void addProperties(Map<ShowlPropertyShape, SynsetProperty> map, SynsetNode synsetNode, Collection<? extends ShowlPropertyShape> propertyCollection) {
        for (ShowlPropertyShape showlPropertyShape : propertyCollection) {
            ShowlPropertyShape q2;
            if (map.get(showlPropertyShape) != null) continue;
            SynsetProperty property = null;
            SynsetNode valueNode = null;
            Set<ShowlPropertyShape> synonyms = showlPropertyShape.synonyms();
            Iterator<ShowlPropertyShape> iterator = synonyms.iterator();
            while (iterator.hasNext() && (property = this.propertyMap.get((q2 = iterator.next()).getPredicate())) == null) {
            }
            if (property == null) {
                property = new SynsetProperty();
            }
            for (ShowlPropertyShape q : synonyms) {
                map.put(q, property);
                property.add(q);
                ShowlNodeShape nested = q.getValueShape();
                if (nested == null) continue;
                if (valueNode == null) {
                    valueNode = new SynsetNode();
                    property.setValueNode(valueNode);
                }
                this.addProperties(map, valueNode, nested);
            }
            synsetNode.addProperty(property);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("addProperties: Add {} to {}", (Object)property.localNames(), (Object)synsetNode.toString());
            logger.isTraceEnabled();
        }
    }

    public List<SynsetProperty> getProperties() {
        return this.propertyList;
    }

    public SynsetProperty findPropertyByPath(List<URI> path) {
        SynsetProperty property = null;
        SynsetNode node = this;
        for (URI predicate : path) {
            if (node == null) {
                return null;
            }
            property = node.findPropertyByPredicate(predicate);
            node = property == null ? null : property.getValueNode();
        }
        return property;
    }

    public SynsetProperty findPropertyByPredicate(URI predicate) {
        return this.propertyMap.get(predicate);
    }

    private void addProperty(SynsetProperty p) {
        if (!this.propertyList.contains(p)) {
            this.propertyList.add(p);
            for (URI predicate : p.getPredicates()) {
                this.propertyMap.put(predicate, p);
            }
        }
    }

    public String toString() {
        for (SynsetProperty p : this.propertyList) {
            Iterator iterator = p.iterator();
            if (!iterator.hasNext()) continue;
            ShowlPropertyShape q = (ShowlPropertyShape)iterator.next();
            return q.getDeclaringShape().getPath();
        }
        return "EmptySynsetNode";
    }
}

