/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlOutwardPropertyShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.SynsetNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.URI;

public class SynsetProperty
extends ArrayList<ShowlPropertyShape> {
    private SynsetNode valueNode;
    private List<URI> predicates = new ArrayList<URI>();

    @Override
    public boolean add(ShowlPropertyShape p) {
        if (!this.contains(p)) {
            this.addPredicate(p.getPredicate());
            return super.add(p);
        }
        return false;
    }

    public List<URI> getPredicates() {
        return this.predicates;
    }

    public String localNames() {
        HashSet<String> set = new HashSet<String>();
        for (ShowlPropertyShape p : this) {
            set.add(p.getPredicate().getLocalName());
        }
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        String comma = "[";
        for (String text : list) {
            builder.append(comma);
            comma = ", ";
            builder.append(text);
        }
        builder.append(']');
        return builder.toString();
    }

    public ShowlDirectPropertyShape direct() {
        for (ShowlPropertyShape p : this) {
            if (!(p instanceof ShowlDirectPropertyShape)) continue;
            return (ShowlDirectPropertyShape)p;
        }
        return null;
    }

    public ShowlOutwardPropertyShape outFormula() {
        for (ShowlPropertyShape p : this) {
            if (!(p instanceof ShowlOutwardPropertyShape) || p.getFormula() == null) continue;
            return (ShowlOutwardPropertyShape)p;
        }
        return null;
    }

    public ShowlPropertyShape select() {
        ShowlPropertyShape p = this.direct();
        if (p == null && (p = this.outFormula()) == null && !this.isEmpty()) {
            p = (ShowlPropertyShape)this.get(0);
        }
        return p;
    }

    private void addPredicate(URI predicate) {
        if (!this.predicates.contains(predicate)) {
            String localName = predicate.getLocalName();
            for (int i = 0; i < this.predicates.size(); ++i) {
                URI p = this.predicates.get(i);
                int compare = localName.compareTo(p.getLocalName());
                if (compare == 0) {
                    String namespace = predicate.getNamespace();
                    if (namespace.compareTo(p.getNamespace()) <= 0) continue;
                    this.predicates.add(i + 1, predicate);
                    return;
                }
                if (compare <= 0) continue;
                this.predicates.add(i + 1, predicate);
                return;
            }
            this.predicates.add(predicate);
        }
    }

    public SynsetNode getValueNode() {
        return this.valueNode;
    }

    public void setValueNode(SynsetNode valueNode) {
        this.valueNode = valueNode;
    }
}

