/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlDerivedPropertyList;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlUniqueKey;
import io.konig.core.showl.ShowlUniqueKeyCollection;
import io.konig.core.showl.SynsetNode;
import io.konig.core.showl.SynsetProperty;
import io.konig.core.showl.UniqueKeyElement;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.OwlVocab;
import io.konig.shacl.PropertyConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class UniqueKeyFactory {
    private OwlReasoner reasoner;

    public UniqueKeyFactory(OwlReasoner reasoner) {
        this.reasoner = reasoner;
    }

    public ShowlUniqueKeyCollection createKeyCollection(ShowlNodeShape node) throws ShowlProcessingException {
        Worker worker = new Worker();
        return worker.createKeyList(node);
    }

    private class Worker {
        Map<URI, List<List<URI>>> owlKeyMap = new HashMap<URI, List<List<URI>>>();
        ShowlUniqueKeyCollection keyCollection;

        private Worker() {
        }

        ShowlUniqueKeyCollection createKeyList(ShowlNodeShape node) throws ShowlProcessingException {
            this.keyCollection = new ShowlUniqueKeyCollection(node);
            SynsetNode snode = node.synsetNode();
            for (SynsetProperty p : snode.getProperties()) {
                if (!this.isKonigId(p) && !this.isShowlUniqueKey(p) && !this.isInverseFunctional(p)) continue;
                this.singleKey(p.select());
            }
            this.buildOwlKeys(node);
            for (ShowlUniqueKey key : this.keyCollection) {
                Collections.sort(key);
                this.addNestedKeys(key);
            }
            Collections.sort(this.keyCollection);
            return this.keyCollection;
        }

        private boolean isInverseFunctional(SynsetProperty synset) {
            for (ShowlPropertyShape p : synset) {
                if (!this.isInverseFunctional(p) && !this.isShowlInverseFunctional(p.getTargetProperty())) continue;
                return true;
            }
            return false;
        }

        private boolean isShowlInverseFunctional(ShowlPropertyShapeGroup group) {
            if (group != null) {
                return this.isInverseFunctional(group.bestTarget());
            }
            return false;
        }

        private boolean isShowlUniqueKey(SynsetProperty synset) {
            for (ShowlPropertyShape p : synset) {
                if (!this.isShowlUniqueKey(p) && !this.isShowlUniqueKey(p.getTargetProperty())) continue;
                return true;
            }
            return false;
        }

        private boolean isShowlUniqueKey(ShowlPropertyShapeGroup group) {
            if (group != null) {
                return this.isShowlUniqueKey(group.bestTarget());
            }
            return false;
        }

        private boolean isKonigId(SynsetProperty synset) {
            for (URI predicate : synset.getPredicates()) {
                if (!Konig.id.equals((Object)predicate)) continue;
                return true;
            }
            return false;
        }

        private void addNestedKeys(ShowlUniqueKey key) throws ShowlProcessingException {
            for (UniqueKeyElement e : key) {
                ShowlPropertyShape p = e.getPropertyShape();
                ShowlNodeShape node = p.getValueShape();
                if (node == null) continue;
                ShowlUniqueKeyCollection c = UniqueKeyFactory.this.createKeyCollection(node);
                e.setValueKeys(c);
            }
        }

        private void buildOwlKeys(ShowlNodeShape node) throws ShowlProcessingException {
            List<List<URI>> owlHasKey = this.owlHasKey(node);
            if (owlHasKey != null && !owlHasKey.isEmpty()) {
                for (List<URI> keyPredicates : owlHasKey) {
                    if (!this.acceptKey(node, keyPredicates)) continue;
                    ShowlUniqueKey key = this.createKey(node, keyPredicates);
                    this.addKey(key);
                }
            }
        }

        private void addKey(ShowlUniqueKey key) {
            if (key == null) {
                return;
            }
            Iterator sequence = this.keyCollection.iterator();
            while (sequence.hasNext()) {
                ShowlUniqueKey other = (ShowlUniqueKey)sequence.next();
                if (key.containsAll(other)) {
                    return;
                }
                if (!other.containsAll(key)) continue;
                sequence.remove();
            }
            this.keyCollection.add(key);
        }

        private ShowlUniqueKey createKey(ShowlNodeShape node, List<URI> keyPredicates) throws ShowlProcessingException {
            ShowlUniqueKey key = new ShowlUniqueKey();
            for (URI predicate : keyPredicates) {
                ShowlDerivedPropertyList list;
                ShowlPropertyShape p = node.getProperty(predicate);
                if (p == null && (list = node.getDerivedProperty(predicate)) != null && !list.isEmpty()) {
                    p = list.withFormula();
                }
                if (p == null) {
                    return null;
                }
                key.add(this.element(p));
            }
            return key;
        }

        private boolean acceptKey(ShowlNodeShape node, List<URI> keyPredicates) {
            for (URI predicate : keyPredicates) {
                if (node.getProperty(predicate) != null) continue;
                return false;
            }
            return true;
        }

        private boolean isInverseFunctional(ShowlPropertyShape p) {
            return p != null && UniqueKeyFactory.this.reasoner.isInverseFunctionalProperty(p.getPredicate());
        }

        private ShowlUniqueKey singleKey(ShowlPropertyShape p) throws ShowlProcessingException {
            ShowlPropertyShapeGroup pGroup = p.asGroup();
            for (ShowlUniqueKey key : this.keyCollection) {
                for (UniqueKeyElement e : key) {
                    ShowlPropertyShapeGroup keyGroup = e.getPropertyShape().asGroup();
                    if (pGroup != keyGroup) continue;
                    if (key.size() == 1) {
                        return null;
                    }
                    Iterator sequence = key.iterator();
                    while (sequence.hasNext()) {
                        UniqueKeyElement e2 = (UniqueKeyElement)sequence.next();
                        if (e2 == e) continue;
                        sequence.remove();
                    }
                    return null;
                }
            }
            ShowlUniqueKey key = new ShowlUniqueKey(this.element(p));
            this.keyCollection.add(key);
            return key;
        }

        private UniqueKeyElement element(ShowlPropertyShape p) throws ShowlProcessingException {
            return new UniqueKeyElement(p);
        }

        private boolean isShowlUniqueKey(ShowlPropertyShape p) {
            URI stereotype;
            PropertyConstraint constraint = p == null ? null : p.getPropertyConstraint();
            URI uRI = stereotype = constraint == null ? null : constraint.getStereotype();
            return stereotype != null && (Konig.primaryKey.equals((Object)stereotype) || Konig.syntheticKey.equals((Object)stereotype) || Konig.uniqueKey.equals((Object)stereotype));
        }

        private List<List<URI>> owlHasKey(ShowlNodeShape node) {
            List<Vertex> keyList;
            Graph graph;
            Vertex v;
            URI classId = node.getOwlClass().getId();
            List<List<URI>> list = this.owlKeyMap.get(classId);
            if (list == null && (v = (graph = UniqueKeyFactory.this.reasoner.getGraph()).getVertex((Resource)classId)) != null && !(keyList = v.asTraversal().out(OwlVocab.hasKey).toVertexList()).isEmpty()) {
                list = new ArrayList<List<URI>>();
                this.owlKeyMap.put(classId, list);
                for (Vertex k : keyList) {
                    List<Value> valueList = k.asList();
                    ArrayList<URI> uriList = new ArrayList<URI>();
                    for (Value value : valueList) {
                        URI uri = RdfUtil.uri(value);
                        if (uri == null) continue;
                        uriList.add(uri);
                    }
                    list.add(uriList);
                }
            }
            return list;
        }
    }
}

