/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlUniqueKey;
import io.konig.core.showl.ShowlUniqueKeyCollection;
import io.konig.core.showl.UniqueKeyElement;
import io.konig.core.vocab.Konig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class UniqueKeySelector {
    private OwlReasoner reasoner;

    public UniqueKeySelector(OwlReasoner reasoner) {
        this.reasoner = reasoner;
    }

    public Map<ShowlNodeShape, ShowlUniqueKey> selectBestKey(List<ShowlUniqueKeyCollection> collectionList) {
        HashMap<ShowlNodeShape, ShowlUniqueKey> result = new HashMap<ShowlNodeShape, ShowlUniqueKey>();
        if (collectionList.isEmpty()) {
            return result;
        }
        ShowlUniqueKeyCollection firstCollection = collectionList.get(0);
        ArrayList<ShowlUniqueKey> candidateList = new ArrayList<ShowlUniqueKey>(firstCollection);
        for (int i = 1; i < collectionList.size(); ++i) {
            ShowlUniqueKeyCollection otherCollection = collectionList.get(i);
            Iterator sequence = candidateList.iterator();
            while (sequence.hasNext()) {
                ShowlUniqueKey candidate = (ShowlUniqueKey)sequence.next();
                if (otherCollection.findMatch(candidate) != null) continue;
                sequence.remove();
            }
        }
        ShowlUniqueKey bestKey = this.bestKey(candidateList);
        if (bestKey != null) {
            result.put(firstCollection.getNodeShape(), bestKey);
            for (int i = 1; i < collectionList.size(); ++i) {
                ShowlUniqueKeyCollection otherCollection = collectionList.get(i);
                ShowlUniqueKey match = otherCollection.findMatch(bestKey);
                if (match == null) {
                    result.clear();
                    return result;
                }
                result.put(otherCollection.getNodeShape(), match);
            }
        }
        return result;
    }

    private ShowlUniqueKey bestKey(List<ShowlUniqueKey> candidateList) {
        if (candidateList.isEmpty()) {
            return null;
        }
        ShowlUniqueKey best = null;
        best = this.idKey(candidateList);
        return best != null ? best : ((best = this.numericKey(candidateList)) != null ? best : ((best = this.simpleKey(candidateList)) != null ? best : this.smallestKey(candidateList)));
    }

    private ShowlUniqueKey smallestKey(List<ShowlUniqueKey> list) {
        int minCount = Integer.MAX_VALUE;
        ShowlUniqueKey best = null;
        for (ShowlUniqueKey key : list) {
            int count = this.leafElementCount(key);
            if (count >= minCount && (count != minCount || key.compareTo(best) >= 0)) continue;
            minCount = count;
            best = key;
        }
        return best;
    }

    private int leafElementCount(ShowlUniqueKey key) {
        int sum = 0;
        for (UniqueKeyElement element : key) {
            sum += this.leafElementCount(element);
        }
        return sum;
    }

    private int leafElementCount(UniqueKeyElement element) {
        if (element.getValueKeys() == null) {
            return 1;
        }
        ShowlUniqueKey key = element.getSelectedKey();
        if (key == null) {
            key = this.bestKey(element.getValueKeys());
            element.setSelectedKey(key);
        }
        return this.leafElementCount(key);
    }

    private ShowlUniqueKey simpleKey(List<ShowlUniqueKey> list) {
        for (ShowlUniqueKey key : list) {
            ShowlPropertyShape p;
            URI valueType;
            if (key.size() != 1 || !this.reasoner.isDatatype((Resource)(valueType = (p = ((UniqueKeyElement)key.get(0)).getPropertyShape()).getValueType(this.reasoner)))) continue;
            return key;
        }
        return null;
    }

    private ShowlUniqueKey numericKey(List<ShowlUniqueKey> list) {
        for (ShowlUniqueKey key : list) {
            ShowlPropertyShape p;
            URI valueType;
            if (key.size() != 1 || !this.reasoner.isNumericDatatype(valueType = (p = ((UniqueKeyElement)key.get(0)).getPropertyShape()).getValueType(this.reasoner))) continue;
            return key;
        }
        return null;
    }

    private ShowlUniqueKey idKey(List<ShowlUniqueKey> list) {
        for (ShowlUniqueKey key : list) {
            if (key.size() != 1 || !((UniqueKeyElement)key.get(0)).getPropertyShape().getPredicate().equals((Object)Konig.id)) continue;
            return key;
        }
        return null;
    }
}

