/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl.expression;

import io.konig.core.Vertex;
import io.konig.core.showl.ShowlBinaryRelationalExpression;
import io.konig.core.showl.ShowlCaseStatement;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlContainmentOperator;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEnumIndividualReference;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlFilterExpression;
import io.konig.core.showl.ShowlFunctionExpression;
import io.konig.core.showl.ShowlIdRefPropertyShape;
import io.konig.core.showl.ShowlInwardPropertyShape;
import io.konig.core.showl.ShowlIriReferenceExpression;
import io.konig.core.showl.ShowlListRelationalExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeService;
import io.konig.core.showl.ShowlOutwardPropertyShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.ShowlWhenThenClause;
import io.konig.core.showl.expression.ShowlLiteralExpression;
import io.konig.core.vocab.Konig;
import io.konig.formula.BareExpression;
import io.konig.formula.BinaryRelationalExpression;
import io.konig.formula.CaseStatement;
import io.konig.formula.ConditionalOrExpression;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.Expression;
import io.konig.formula.Formula;
import io.konig.formula.FormulaUtil;
import io.konig.formula.FunctionExpression;
import io.konig.formula.GeneralAdditiveExpression;
import io.konig.formula.HasPathStep;
import io.konig.formula.IriTemplateExpression;
import io.konig.formula.IriValue;
import io.konig.formula.ListRelationalExpression;
import io.konig.formula.LiteralFormula;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PredicateObjectList;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.VariableTerm;
import io.konig.formula.WhenThenClause;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlExpressionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ShowlExpressionBuilder.class);
    private ShowlSchemaService schemaService;
    private ShowlNodeShapeService nodeService;
    private transient ShowlNodeShape pathRoot;

    public ShowlExpressionBuilder(ShowlSchemaService schemaService, ShowlNodeShapeService nodeService) {
        this.schemaService = schemaService;
        this.nodeService = nodeService;
    }

    public ShowlExpression expression(ShowlPropertyShape p) throws ShowlProcessingException {
        QuantifiedExpression formula;
        ShowlDirectPropertyShape direct = p.direct();
        if (direct != null) {
            return new ShowlDirectPropertyExpression(direct);
        }
        Set<ShowlExpression> hasValue = p.getHasValue();
        if (hasValue.size() > 1) {
            throw new ShowlProcessingException("Cannot handle multiple 'hasValue' constraints at " + p.getPath());
        }
        if (hasValue.size() == 1) {
            return hasValue.iterator().next();
        }
        PropertyConstraint c = p.getPropertyConstraint();
        if (c != null && (formula = c.getFormula()) != null) {
            return this.expression(p, formula);
        }
        throw new ShowlProcessingException("Cannot construct expression for " + p.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShowlExpression expression(ShowlPropertyShape p, Formula formula) throws ShowlProcessingException {
        boolean newRoot;
        if (formula == null) {
            return null;
        }
        boolean bl = newRoot = this.pathRoot == null;
        if (newRoot) {
            this.pathRoot = p.getDeclaringShape();
        }
        try {
            if (formula instanceof FunctionExpression) {
                ShowlFunctionExpression showlFunctionExpression = this.functionExpression(p, (FunctionExpression)formula);
                return showlFunctionExpression;
            }
            if (formula instanceof QuantifiedExpression) {
                ShowlExpression showlExpression = this.quantifiedExpression(p, (QuantifiedExpression)formula);
                return showlExpression;
            }
            if (formula instanceof ConditionalOrExpression) {
                ShowlExpression showlExpression = this.conditionalOr(p, (ConditionalOrExpression)formula);
                return showlExpression;
            }
            if (formula instanceof PathExpression) {
                ShowlExpression showlExpression = this.path(p, (PathExpression)formula);
                return showlExpression;
            }
            if (formula instanceof BareExpression) {
                ShowlExpression showlExpression = this.bare(p, (BareExpression)formula);
                return showlExpression;
            }
            if (formula instanceof IriValue) {
                ShowlExpression showlExpression = this.iriValue(p, (IriValue)formula);
                return showlExpression;
            }
            if (formula instanceof LiteralFormula) {
                ShowlExpression showlExpression = this.literal((LiteralFormula)formula);
                return showlExpression;
            }
            if (formula instanceof IriTemplateExpression) {
                ShowlExpression showlExpression = this.iriTemplate(p, (IriTemplateExpression)formula);
                return showlExpression;
            }
            if (formula instanceof ListRelationalExpression) {
                ShowlListRelationalExpression showlListRelationalExpression = this.listRelational(p, (ListRelationalExpression)formula);
                return showlListRelationalExpression;
            }
            if (formula instanceof CaseStatement) {
                ShowlExpression showlExpression = this.caseStatement(p, (CaseStatement)formula);
                return showlExpression;
            }
            if (formula instanceof GeneralAdditiveExpression) {
                ShowlExpression showlExpression = this.additive(p, (GeneralAdditiveExpression)formula);
                return showlExpression;
            }
            this.fail("At {0}, failed to process expression: {1}", p.getPath(), FormulaUtil.simpleString(formula));
            ShowlExpression showlExpression = null;
            return showlExpression;
        }
        finally {
            if (newRoot) {
                this.pathRoot = null;
            }
        }
    }

    private ShowlExpression additive(ShowlPropertyShape p, GeneralAdditiveExpression formula) {
        PrimaryExpression primary = formula.asPrimaryExpression();
        if (primary != null) {
            return this.expression(p, primary);
        }
        this.fail("At {0}, failed to process expression: {1}", p.getPath(), FormulaUtil.simpleString(formula));
        return null;
    }

    private ShowlExpression caseStatement(ShowlPropertyShape p, CaseStatement formula) {
        ArrayList<ShowlWhenThenClause> whenThenList = new ArrayList<ShowlWhenThenClause>();
        for (WhenThenClause clause : formula.getWhenThenList()) {
            whenThenList.add(new ShowlWhenThenClause(this.expression(p, clause.getWhen()), this.expression(p, clause.getThen())));
        }
        return new ShowlCaseStatement(this.expression(p, formula.getCaseCondition()), whenThenList, this.expression(p, formula.getElseClause()));
    }

    private ShowlListRelationalExpression listRelational(ShowlPropertyShape p, ListRelationalExpression formula) {
        ShowlContainmentOperator operator = null;
        switch (formula.getOperator()) {
            case IN: {
                operator = ShowlContainmentOperator.IN;
                break;
            }
            case NOT_IN: {
                operator = ShowlContainmentOperator.NOT_IN;
            }
        }
        ShowlExpression left = this.expression(p, formula.getLeft());
        ArrayList<ShowlExpression> right = new ArrayList<ShowlExpression>();
        for (Expression e : formula.getRight()) {
            right.add(this.expression(p, e));
        }
        return new ShowlListRelationalExpression(p, left, operator, right);
    }

    private ShowlExpression iriTemplate(ShowlPropertyShape p, IriTemplateExpression formula) {
        return ShowlFunctionExpression.fromIriTemplate(this.schemaService, this.nodeService, p, formula.getTemplate());
    }

    private ShowlExpression iriValue(ShowlPropertyShape p, IriValue formula) {
        URI iri = formula.getIri();
        ShowlNodeShape parent = p.getValueShape() == null ? p.getDeclaringShape() : p.getValueShape();
        ShowlPropertyShape out = parent.findOut(iri);
        if (out != null) {
            return this.propertyExpression(out);
        }
        Vertex v = this.schemaService.getOwlReasoner().getGraph().getVertex((Resource)iri);
        if (v != null) {
            return new ShowlEnumIndividualReference(iri);
        }
        ShowlIriReferenceExpression result = new ShowlIriReferenceExpression(iri, p);
        return result;
    }

    private ShowlPropertyExpression asPropertyExpression(ShowlPropertyShape p) {
        if (p instanceof ShowlDirectPropertyShape) {
            return new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)p);
        }
        return new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)p);
    }

    private ShowlExpression propertyExpression(ShowlPropertyShape out) {
        if ((out = out.maybeDirect()) instanceof ShowlDirectPropertyShape) {
            return new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)out);
        }
        return new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)out);
    }

    private ShowlExpression literal(LiteralFormula formula) {
        return new ShowlLiteralExpression(formula.getLiteral());
    }

    private ShowlExpression conditionalOr(ShowlPropertyShape p, ConditionalOrExpression formula) {
        PrimaryExpression primary = formula.asPrimaryExpression();
        if (primary != null) {
            return this.expression(p, primary);
        }
        ListRelationalExpression listRelational = formula.asListRelationalExpression();
        if (listRelational != null) {
            return this.listRelational(p, listRelational);
        }
        BinaryRelationalExpression binaryRelational = formula.asBinaryRelationalExpression();
        if (binaryRelational != null) {
            return this.binaryRelational(p, binaryRelational);
        }
        this.fail("At {0}, failed to process conditional or expression {1}", p.getPath(), FormulaUtil.simpleString(formula));
        return null;
    }

    private ShowlExpression binaryRelational(ShowlPropertyShape p, BinaryRelationalExpression binaryRelational) {
        ShowlExpression left = this.expression(p, binaryRelational.getLeft());
        ShowlExpression right = this.expression(p, binaryRelational.getRight());
        return new ShowlBinaryRelationalExpression(binaryRelational.getOperator(), left, right);
    }

    private ShowlExpression bare(ShowlPropertyShape p, BareExpression formula) {
        PrimaryExpression primary = formula.asPrimaryExpression();
        if (primary == null) {
            this.fail("At {0}, failed to process bare expression {1}", p.getPath(), FormulaUtil.simpleString(formula));
        }
        return this.expression(p, primary);
    }

    private ShowlExpression path(ShowlPropertyShape p, PathExpression formula) {
        return this.path(p, this.pathRoot, null, formula);
    }

    private ShowlExpression path(ShowlPropertyShape p, ShowlNodeShape root, ShowlPropertyShape prior, PathExpression formula) {
        List<PathStep> stepList = formula.getStepList();
        String shapeIdValue = p.getDeclaringShape().getId().stringValue();
        for (int i = 0; i < stepList.size(); ++i) {
            ShowlNodeShape valueShape;
            ShowlProperty property;
            PathStep step = stepList.get(i);
            if (step instanceof DirectionStep) {
                DirectionStep dirStep = (DirectionStep)step;
                URI predicate = dirStep.getTerm().getIri();
                property = this.schemaService.produceProperty(predicate);
                ShowlNodeShape parentNode = this.parentNode(shapeIdValue, dirStep, property, p, root, prior);
                shapeIdValue = shapeIdValue + dirStep.getDirection().getSymbol() + predicate.getLocalName();
                switch (dirStep.getDirection()) {
                    case OUT: {
                        prior = this.outwardProperty(parentNode, property, prior, p);
                        break;
                    }
                    case IN: {
                        prior = this.inwardProperty(parentNode, property);
                    }
                }
                continue;
            }
            HasPathStep hasStep = (HasPathStep)step;
            if (prior == null) {
                this.fail("At {0}, top-level filter not supported: {1}", p.getPath(), FormulaUtil.simpleString(formula));
            }
            if ((valueShape = prior.getValueShape()) == null) {
                property = this.schemaService.produceProperty(prior.getPredicate());
                ShowlClass owlClass = this.schemaService.inferRange(property);
                valueShape = this.createNodeShape(prior, shapeIdValue, owlClass, p);
                prior.setValueShape(valueShape);
            }
            this.buildHasStep(prior, hasStep);
        }
        return this.asPropertyExpression(prior);
    }

    private void buildHasStep(ShowlPropertyShape prior, HasPathStep step) throws ShowlProcessingException {
        for (PredicateObjectList pol : step.getConstraints()) {
            PathExpression path = pol.getPath();
            ShowlExpression showlPath = this.path(prior, null, prior, path);
            ShowlPropertyShape field = ShowlUtil.asPropertyShape(showlPath);
            if (field == null) {
                this.fail("Cannot convert expression to PropertyShape {}", showlPath.displayValue());
            }
            for (Expression e : pol.getObjectList().getExpressions()) {
                ShowlExpression expression = this.expression(prior, e);
                field.addHasValue(new ShowlFilterExpression(expression));
                if (!logger.isTraceEnabled()) continue;
                logger.trace("buildHasStep: {} = {}", (Object)field.getPath(), (Object)expression.displayValue());
            }
        }
    }

    private ShowlDerivedPropertyShape inwardProperty(ShowlNodeShape parentNode, ShowlProperty property) {
        ShowlInwardPropertyShape prior = parentNode.getInwardProperty(property.getPredicate());
        if (prior != null) {
            return prior;
        }
        ShowlInwardPropertyShape p = new ShowlInwardPropertyShape(parentNode, property);
        parentNode.addInwardProperty(p);
        return p;
    }

    private ShowlDerivedPropertyShape outwardProperty(ShowlNodeShape parentNode, ShowlProperty property, ShowlPropertyShape prior, ShowlPropertyShape declaringProperty) {
        PropertyConstraint c = null;
        if (prior == null) {
            c = new PropertyConstraint(property.getPredicate());
            c.setNodeKind(declaringProperty.getNodeKind());
        }
        ShowlOutwardPropertyShape p = new ShowlOutwardPropertyShape(parentNode, property, c);
        property.addPropertyShape(p);
        parentNode.addDerivedProperty(p);
        return p;
    }

    private ShowlNodeShape createNodeShape(ShowlPropertyShape accessor, String shapeIdValue, ShowlClass owlClass, ShowlPropertyShape idRef) {
        ShowlNodeShape nestedShape;
        ShowlNodeShape value = accessor.getValueShape();
        if (value != null) {
            return value;
        }
        URIImpl shapeId = new URIImpl(shapeIdValue);
        Shape shape = new Shape((Resource)shapeId);
        NodeKind kind = accessor.getNodeKind();
        if (kind == null && (nestedShape = accessor.getValueShape()) != null) {
            kind = nestedShape.getNodeKind();
        }
        shape.setNodeKind(kind);
        ShowlNodeShape node = this.nodeService.createShowlNodeShape(accessor, shape, owlClass);
        if (kind == NodeKind.IRI) {
            ShowlProperty konigId = this.schemaService.produceProperty(Konig.id);
            ShowlIdRefPropertyShape p = new ShowlIdRefPropertyShape(node, konigId, idRef);
            node.addDerivedProperty(p);
        }
        return node;
    }

    private ShowlNodeShape parentNode(String shapeIdValue, DirectionStep dirStep, ShowlProperty property, ShowlPropertyShape p, ShowlNodeShape root, ShowlPropertyShape prior) {
        if (dirStep.getTerm() instanceof VariableTerm) {
            return this.varRoot(dirStep.getTerm().getIri(), p);
        }
        if (prior == null) {
            return root;
        }
        ShowlClass owlClass = this.schemaService.inferDomain(property);
        ShowlProperty priorProperty = prior.getProperty();
        ShowlClass prevClass = dirStep.getDirection() == Direction.OUT ? this.schemaService.inferRange(priorProperty) : this.schemaService.inferDomain(priorProperty);
        owlClass = this.schemaService.mostSpecificClass(owlClass, prevClass);
        return this.createNodeShape(prior, shapeIdValue, owlClass, p);
    }

    private ShowlNodeShape varRoot(URI predicate, ShowlPropertyShape propertyShape) {
        ShowlPropertyShape p = propertyShape;
        while (p != null) {
            ShowlNodeShape node = p.getDeclaringShape();
            Shape shape = node.getShape();
            if (shape == null) {
                this.fail("Declaring Shape is null at {0}", p.getPath());
            }
            if (shape.getVariableById(predicate) != null) {
                return node;
            }
            p = node.getAccessor();
        }
        this.fail("Root node for ?{0} not found in formula of {1}", predicate.getLocalName(), propertyShape.getPath());
        return null;
    }

    private void fail(String pattern, Object ... arg) {
        String msg = MessageFormat.format(pattern, arg);
        throw new ShowlProcessingException(msg);
    }

    private ShowlExpression quantifiedExpression(ShowlPropertyShape p, QuantifiedExpression formula) {
        PrimaryExpression primary = formula.asPrimaryExpression();
        if (primary == null) {
            this.fail("At {0}, failed to process quantified expression {1}", p.getPath(), FormulaUtil.simpleString(formula));
        }
        return this.expression(p, primary);
    }

    public ShowlFunctionExpression functionExpression(ShowlPropertyShape p, FunctionExpression formula) {
        ShowlFunctionExpression func = new ShowlFunctionExpression(p, formula);
        for (Expression arg : formula.getArgList()) {
            func.getArguments().add(this.expression(p, arg));
        }
        return func;
    }
}

