/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.vocab.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;

public class ClassHierarchyPaths
extends ArrayList<List<URI>> {
    private static final long serialVersionUID = 1L;

    public ClassHierarchyPaths(Vertex targetClass) {
        this.build(targetClass);
    }

    private void build(Vertex targetClass) {
        if (targetClass.getId() instanceof URI) {
            ArrayList<URI> list = new ArrayList<URI>();
            URI classId = (URI)targetClass.getId();
            list.add(classId);
            this.add(list);
            this.addSuperClasses(list, targetClass);
        }
        Collections.sort(this, new Comparator<List<URI>>(){

            @Override
            public int compare(List<URI> aList, List<URI> bList) {
                if (aList == bList) {
                    return 0;
                }
                int min = Math.min(aList.size(), bList.size());
                for (int i = 0; i < min; ++i) {
                    URI a = aList.get(i);
                    URI b = bList.get(i);
                    int delta = a.stringValue().compareTo(b.stringValue());
                    if (delta == 0) continue;
                    return delta;
                }
                return aList.size() - bList.size();
            }
        });
    }

    private void addSuperClasses(List<URI> list, Vertex targetClass) {
        Set<URI> superSet = targetClass.asTraversal().out(RDFS.SUBCLASSOF).toUriSet();
        superSet.remove(OWL.THING);
        superSet.remove(Schema.Thing);
        if (!superSet.isEmpty()) {
            boolean multiple;
            boolean bl = multiple = superSet.size() > 1;
            if (multiple) {
                this.remove(list);
            }
            for (URI superId : superSet) {
                Vertex superVertex;
                ArrayList<URI> sink = multiple ? new ArrayList<URI>(list) : list;
                sink.add(superId);
                if (multiple) {
                    this.add(sink);
                }
                if ((superVertex = targetClass.getGraph().getVertex((Resource)superId)) == null) {
                    throw new KonigException("Vertex not found: " + superId.stringValue());
                }
                this.addSuperClasses(sink, superVertex);
            }
        }
    }
}

