/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.Context;
import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.core.util.TermConflictException;
import org.openrdf.model.URI;

public class ContextExtender {
    public Context extend(Context baseline, Context extraTerms) throws TermConflictException {
        BasicContext result = new BasicContext(baseline.getContextIRI());
        baseline.compile();
        extraTerms.compile();
        for (Term term : baseline.asList()) {
            result.add(term);
        }
        for (Term extra : extraTerms.asList()) {
            Term required = baseline.getTerm(extra.getKey());
            if (!this.accept(required, extra)) continue;
            result.add(extra);
        }
        return result;
    }

    private boolean accept(Term a, Term b) throws TermConflictException {
        if (a == null) {
            return true;
        }
        String aId = a.getExpandedIdValue();
        String bId = b.getExpandedIdValue();
        URI aType = a.getExpandedType();
        URI bType = b.getExpandedType();
        if (!aId.equals(bId) || !this.compatible(aType, bType)) {
            throw new TermConflictException(bId, null);
        }
        return false;
    }

    private boolean compatible(URI a, URI b) {
        return a == null || b == null || a != null && a.equals((Object)b);
    }
}

