/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import com.google.common.io.Files;
import io.konig.core.util.RewriteRule;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static Logger logger = LoggerFactory.getLogger(IOUtil.class);

    public static void close(Closeable stream, String name) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable oops) {
                logger.warn("Failed to close " + name, oops);
            }
        }
    }

    public static void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] array;
            for (File child : array = file.listFiles()) {
                IOUtil.recursiveDelete(child);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceAll(File file, List<RewriteRule> rules) throws IOException {
        File tmpFile = File.createTempFile(file.getName(), "tmp", file.getParentFile());
        try {
            try (FileWriter out = new FileWriter(tmpFile);
                 BufferedReader buffered = new BufferedReader(new FileReader(file));){
                String line = null;
                while ((line = buffered.readLine()) != null) {
                    for (RewriteRule rule : rules) {
                        line = line.replace(rule.getSourceString(), rule.getTargetString());
                    }
                    out.write(line);
                    out.write(10);
                }
            }
            Files.copy((File)tmpFile, (File)file);
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringContent(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream is = new FileInputStream(file);
        BufferedReader buf = new BufferedReader(new InputStreamReader(is));
        try {
            String line = buf.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = buf.readLine();
            }
        }
        finally {
            IOUtil.close(buf, file.getAbsolutePath());
        }
        return sb.toString();
    }
}

