/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.Term;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.core.util.SimpleValueFormat;
import io.konig.core.util.ValueFormat;
import io.konig.core.util.ValueMap;
import io.konig.rio.turtle.IriTemplateParseException;
import io.konig.rio.turtle.IriTemplateParser;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class IriTemplate
extends SimpleValueFormat {
    private Context context;

    public IriTemplate(Context context, String text) {
        super(text);
        this.context = context;
    }

    public IriTemplate() {
    }

    public IriTemplate(String text) {
        this.parse(text);
    }

    public IriTemplate clone() {
        IriTemplate other = new IriTemplate();
        other.context = this.context;
        other.elements = new ArrayList();
        for (ValueFormat.Element element : this.toList()) {
            other.elements.add((SimpleValueFormat.Element)element.clone());
        }
        return other;
    }

    private void parse(String input) {
        char c = (input = input.trim()).charAt(0);
        if (c == '@' || c == '<') {
            StringReader reader = new StringReader(input);
            try {
                IriTemplate self = IriTemplateParser.INSTANCE.parse(reader);
                this.context = self.getContext();
                this.text = self.getText();
                this.compile();
            }
            catch (IriTemplateParseException e) {
                throw new KonigException(e);
            }
        } else {
            this.text = input;
            this.compile();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof IriTemplate) {
            IriTemplate t = (IriTemplate)other;
            List<? extends ValueFormat.Element> aList = this.toList();
            List<? extends ValueFormat.Element> bList = t.toList();
            if (aList.size() != bList.size()) {
                return false;
            }
            for (int i = 0; i < aList.size(); ++i) {
                ValueFormat.Element b;
                ValueFormat.Element a = aList.get(i);
                if (a.equals(b = bList.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public URI expand(ValueMap map) {
        return new URIImpl(this.format(map));
    }

    public String getText() {
        return this.text;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Literal toValue() {
        return new LiteralImpl(this.toString(), XMLSchema.STRING);
    }

    @Override
    public String toString() {
        StringWriter buffer = new StringWriter();
        PrettyPrintWriter out = new PrettyPrintWriter(buffer);
        this.print(out);
        out.close();
        return buffer.toString();
    }

    public void print(PrettyPrintWriter out) {
        if (this.context != null) {
            List<Term> list = this.context.asList();
            out.indent();
            out.print("@context {");
            out.pushIndent();
            String comma = "";
            for (Term term : list) {
                out.println(comma);
                term.print(out);
                comma = ",";
            }
            out.popIndent();
            out.println();
            out.indent();
            out.println('}');
            out.println();
        }
        out.indent();
        out.print('<');
        out.print(this.text);
        out.print('>');
    }

    public int variablesCount() {
        int count = 0;
        for (ValueFormat.Element element : this.toList()) {
            if (element.getType() != ValueFormat.ElementType.VARIABLE) continue;
            ++count;
        }
        return count;
    }
}

