/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.Path;
import io.konig.core.impl.RdfUtil;
import io.konig.core.path.OutStep;
import io.konig.core.path.PathImpl;
import io.konig.core.path.Step;
import io.konig.core.util.StringUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;

public class PathPattern {
    private String sourcePrefix;
    private Path path;
    private URI targetClass;

    public PathPattern(String sourcePrefix, URI targetClass, URI predicate) {
        this.sourcePrefix = sourcePrefix;
        this.targetClass = targetClass;
        this.path = new PathImpl();
        this.path.out(predicate);
    }

    public PathPattern(String sourcePrefix, Path path, URI targetClass) {
        this.sourcePrefix = sourcePrefix;
        this.path = path;
        this.targetClass = targetClass;
    }

    public Path getPath() {
        return this.path;
    }

    public String getSourcePrefix() {
        return this.sourcePrefix;
    }

    public URI getTargetClass() {
        return this.targetClass;
    }

    public boolean matches(String sourcePath) {
        return sourcePath.startsWith(this.sourcePrefix);
    }

    public String transform(String sourcePath, NamespaceManager nsManager) {
        if (sourcePath.startsWith(this.sourcePrefix)) {
            String rest = sourcePath.substring(this.sourcePrefix.length());
            String fieldName = StringUtil.camelCase(rest);
            StringBuilder builder = new StringBuilder();
            for (Step step : this.path.asList()) {
                if (step instanceof OutStep) {
                    OutStep out = (OutStep)step;
                    URI predicate = out.getPredicate();
                    String curie = RdfUtil.optionalCurie(nsManager, predicate);
                    builder.append('/');
                    builder.append(curie);
                    continue;
                }
                throw new KonigException("Step type not supported: " + step.getClass().getSimpleName());
            }
            builder.append('/');
            if (this.targetClass == null) {
                builder.append(fieldName);
            } else {
                String namespace = this.targetClass.getNamespace();
                Namespace ns = nsManager.findByName(namespace);
                if (ns == null) {
                    builder.append('<');
                    builder.append(namespace);
                    builder.append(fieldName);
                    builder.append('>');
                } else {
                    builder.append(ns.getPrefix());
                    builder.append(':');
                    builder.append(fieldName);
                }
            }
            return builder.toString();
        }
        return null;
    }
}

