/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.util.ValueExpander;
import io.konig.core.util.ValueFormat;
import io.konig.core.util.ValueFormatVisitor;
import io.konig.core.util.ValueMap;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;

public class SimpleValueFormat
implements ValueFormat {
    protected String text;
    protected List<Element> elements;

    public SimpleValueFormat() {
    }

    public SimpleValueFormat(String text) {
        if (text != null) {
            this.text = text.trim();
            this.compile();
        }
    }

    protected Element createVariable(String text) {
        return new Variable(text);
    }

    protected void compile() {
        int c;
        this.elements = new ArrayList<Element>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.text.length(); i += Character.charCount(c)) {
            String value;
            c = this.text.codePointAt(i);
            if (c == 123) {
                if (buffer.length() <= 0) continue;
                value = buffer.toString();
                this.elements.add(new Element(value));
                buffer = new StringBuilder();
                continue;
            }
            if (c == 125) {
                value = buffer.toString();
                this.elements.add(this.createVariable(value));
                buffer = new StringBuilder();
                continue;
            }
            buffer.appendCodePoint(c);
        }
        if (buffer.length() > 0) {
            String value = buffer.toString();
            this.elements.add(new Element(value));
        }
    }

    @Override
    public String format(ValueMap map) {
        StringBuilder builder = new StringBuilder();
        for (Element e : this.elements) {
            String value = e.get(map);
            if (value == null) {
                builder.append('{');
                builder.append(e.text);
                builder.append('}');
                continue;
            }
            value = ValueExpander.expand(value, map);
            builder.append(value);
        }
        return builder.toString();
    }

    public String toString() {
        return this.text;
    }

    @Override
    public void traverse(ValueFormatVisitor visitor) {
        for (Element e : this.elements) {
            if (e instanceof Variable) {
                visitor.visitVariable(e.text);
                continue;
            }
            visitor.visitText(e.text);
        }
    }

    public Value toValue() {
        return new LiteralImpl(this.text);
    }

    @Override
    public String getPattern() {
        return this.text;
    }

    @Override
    public List<? extends ValueFormat.Element> toList() {
        return this.elements;
    }

    @Override
    public void addText(String text) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(new Element(text));
        this.text = this.text == null ? text : this.text + text;
    }

    @Override
    public void addVariable(String variable) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(new Variable(variable));
        StringBuilder builder = this.text == null ? new StringBuilder() : new StringBuilder(this.text);
        builder.append('{');
        builder.append(variable);
        builder.append('}');
        this.text = builder.toString();
    }

    static class Variable
    extends Element {
        public Variable(String text) {
            super(text);
        }

        @Override
        public Variable clone() {
            return new Variable(this.text);
        }

        @Override
        public ValueFormat.ElementType getType() {
            return ValueFormat.ElementType.VARIABLE;
        }

        @Override
        String get(ValueMap map) {
            return map.get(this.text);
        }
    }

    static class Element
    implements ValueFormat.Element {
        protected String text;

        @Override
        public Element clone() {
            return new Element(this.text);
        }

        public Element(String text) {
            this.text = text;
        }

        String get(ValueMap map) {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        @Override
        public ValueFormat.ElementType getType() {
            return ValueFormat.ElementType.TEXT;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public boolean equals(Object other) {
            if (other.getClass() == this.getClass()) {
                Element e = (Element)other;
                return this.text.equals(e.getText());
            }
            return false;
        }
    }
}

