/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.DatatypeRestriction;
import io.konig.core.OwlReasoner;
import io.konig.core.util.BasicJavaDatatypeMapper;
import org.openrdf.model.URI;

public class SmartJavaDatatypeMapper
extends BasicJavaDatatypeMapper {
    private OwlReasoner reasoner;

    public SmartJavaDatatypeMapper(OwlReasoner reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public Class<?> javaDatatype(URI datatype) {
        URI type;
        if ("http://www.w3.org/2001/XMLSchema#".equals(datatype.getNamespace())) {
            return super.javaDatatype(datatype);
        }
        DatatypeRestriction r = this.reasoner.datatypeRestriction(datatype);
        if (r != null && (type = r.getOnDatatype()) != null && "http://www.w3.org/2001/XMLSchema#".equals(type.getNamespace())) {
            return super.javaDatatype(type);
        }
        throw new RuntimeException("Java datatype not found: " + datatype);
    }

    @Override
    public Class<?> primitive(Class<?> javaType) {
        return super.primitive(javaType);
    }
}

