/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

public class StringUtil {
    private static final int OTHER = 0;
    private static final int DELIM = 0;
    private static final int LOWER = 1;
    private static final int UPPER = 2;
    private static final int WORD_BOUNDARY = 3;
    private static final String DELIMITER = "_-./:";

    public static final String label(String technicalName) {
        if ((technicalName = technicalName.trim()).indexOf(32) > 0) {
            return technicalName;
        }
        int prior = 0;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < technicalName.length()) {
            int thisCase;
            int c = technicalName.codePointAt(i);
            i += Character.charCount(c);
            if (!Character.isAlphabetic(c)) {
                if (c == 95 || c == 46) {
                    c = 32;
                }
                builder.appendCodePoint(c);
                prior = c;
                continue;
            }
            if (prior == 32 || builder.length() == 0) {
                c = Character.toUpperCase(c);
                builder.appendCodePoint(c);
                prior = c;
                continue;
            }
            int priorCase = StringUtil.caseValue(prior);
            if (priorCase != (thisCase = StringUtil.caseValue(c))) {
                if (Character.isAlphabetic(prior) && priorCase == 1) {
                    builder.append(' ');
                }
                prior = c;
                builder.appendCodePoint(c);
                continue;
            }
            builder.appendCodePoint(c);
            prior = c;
        }
        return builder.toString();
    }

    public static final String normalizedLocalName(String label) {
        StringBuilder builder = new StringBuilder();
        label = label.trim();
        int prior = 0;
        int i = 0;
        while (i < label.length()) {
            int c = label.codePointAt(i);
            i += Character.charCount(c);
            if (Character.isWhitespace(c)) {
                c = 95;
            }
            if (!Character.isAlphabetic(c) && !Character.isDigit(c) && c != 45 && c != 95) {
                if (prior != 95) {
                    builder.append('_');
                }
                builder.append('x');
                builder.append(Integer.toHexString(c));
                builder.append('_');
                prior = 95;
                continue;
            }
            builder.appendCodePoint(c);
            prior = c;
        }
        if (builder.charAt(builder.length() - 1) == '_') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static final String LABEL_TO_SNAKE_CASE(String label) {
        StringBuilder builder = new StringBuilder();
        label = label.trim();
        int priorCase = 0;
        int prior = 95;
        int k = label.codePointAt(0);
        if (!Character.isAlphabetic(k) && !Character.isDigit(k)) {
            builder.append('_');
        }
        int i = 0;
        while (i < label.length()) {
            int c = label.codePointAt(i);
            char ch = (char)c;
            i += Character.charCount(c);
            if (!Character.isAlphabetic(c) && !Character.isDigit(c)) {
                if (c == 45 || Character.isWhitespace(c) || c == 95) {
                    builder.append('_');
                    prior = 95;
                    priorCase = 0;
                    continue;
                }
                if (prior != 95) {
                    builder.append('_');
                }
                builder.append('x');
                builder.append(Integer.toHexString(c));
                builder.append('_');
                prior = 95;
                priorCase = 0;
                continue;
            }
            int caseValue = StringUtil.caseValue(c);
            if (i >= 2 && caseValue != 0 && prior != 95 && caseValue != priorCase && c != 95 && builder.length() >= 2 && builder.charAt(builder.length() - 2) != '_') {
                builder.append('_');
            }
            prior = c;
            priorCase = caseValue;
            builder.appendCodePoint(Character.toUpperCase(c));
        }
        while (builder.length() > 0 && builder.charAt(builder.length() - 1) == '_') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static final String SNAKE_CASE(String text) {
        int c;
        StringBuilder builder = new StringBuilder();
        if (text.indexOf(95) > 0) {
            return text.toUpperCase();
        }
        int priorCase = 0;
        int prior = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(c)) {
            c = text.codePointAt(i);
            int caseValue = StringUtil.caseValue(c);
            if (i > 1 && caseValue != 0 && prior != 95 && caseValue != priorCase && builder.codePointAt(builder.length() - 2) != 95) {
                builder.append('_');
            }
            prior = c;
            priorCase = caseValue;
            builder.appendCodePoint(Character.toUpperCase(c));
        }
        return builder.toString();
    }

    private static int caseValue(int c) {
        if (Character.isAlphabetic(c)) {
            if (Character.isUpperCase(c)) {
                return 2;
            }
            if (Character.isLowerCase(c)) {
                return 1;
            }
        }
        return 0;
    }

    public static final String capitalize(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String PascalCase(String text) {
        StringBuilder builder = new StringBuilder();
        int charType = 0;
        int i = 0;
        while (i < text.length()) {
            int newCharType;
            int c = text.codePointAt(i);
            i += Character.charCount(c);
            if (DELIMITER.indexOf(c) >= 0) {
                charType = 0;
                continue;
            }
            int n = newCharType = Character.isUpperCase(c) ? 2 : 1;
            if (charType == 0) {
                c = Character.toUpperCase(c);
                newCharType = 2;
            } else if (charType != 1 || newCharType != 2) {
                c = Character.toLowerCase(c);
            }
            charType = newCharType;
            builder.appendCodePoint(c);
        }
        return builder.toString();
    }

    public static String camelCase(String text) {
        StringBuilder builder = new StringBuilder();
        boolean firstWord = true;
        int charType = 0;
        int i = 0;
        while (i < text.length()) {
            int newCharType;
            int c = text.codePointAt(i);
            i += Character.charCount(c);
            if (DELIMITER.indexOf(c) >= 0) {
                charType = 0;
                continue;
            }
            int n = newCharType = Character.isUpperCase(c) ? 2 : 1;
            if (charType == 0) {
                if (firstWord) {
                    c = Character.toLowerCase(c);
                    firstWord = false;
                } else {
                    c = Character.toUpperCase(c);
                }
                newCharType = 2;
            } else if (charType != 1 || newCharType != 2) {
                c = Character.toLowerCase(c);
            }
            charType = newCharType;
            builder.appendCodePoint(c);
        }
        return builder.toString();
    }

    public static final String firstLetterLowerCase(String text) {
        StringBuilder builder = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static final String javaSimpleName(String fullyQualifiedClassName) {
        int dot = fullyQualifiedClassName.lastIndexOf(46);
        if (dot > 0) {
            return fullyQualifiedClassName.substring(dot + 1);
        }
        return fullyQualifiedClassName;
    }

    public static final String rdfLocalName(String fullyQualifiedIRI) {
        int hash = fullyQualifiedIRI.lastIndexOf(35);
        if (hash >= 0) {
            return fullyQualifiedIRI.substring(hash + 1);
        }
        int slash = fullyQualifiedIRI.lastIndexOf(47);
        if (slash >= 0) {
            return fullyQualifiedIRI.substring(slash + 1);
        }
        return null;
    }

    public static String mediaTypePart(String source) {
        int c;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < source.length(); i += Character.charCount(c)) {
            c = source.codePointAt(i);
            if (!Character.isAlphabetic(c) && !Character.isDigit(c)) {
                c = 45;
            }
            builder.appendCodePoint(c);
        }
        return builder.toString();
    }

    public static String javaIdentifier(String text) {
        char c;
        text = text.replace("%20", "_");
        int first = text.codePointAt(0);
        StringBuilder builder = new StringBuilder();
        if (!Character.isJavaIdentifierStart(first)) {
            builder.append('_');
        }
        for (int i = 0; i < text.length(); i += Character.charCount(c)) {
            c = text.charAt(i);
            if (Character.isJavaIdentifierPart((int)c)) {
                builder.appendCodePoint(c);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }
}

