/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.util;

import io.konig.core.Context;
import io.konig.core.Term;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.turtle.TurtleUtil;

public class TurtleElements {
    public static String iri(Context context, URI resource) {
        String iriValue = resource.stringValue();
        if (context != null) {
            Context inverse = context.inverse();
            Term term = inverse.getTerm(iriValue);
            if (term != null) {
                return term.getKey();
            }
            term = inverse.getTerm(resource.getNamespace());
            if (term != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(term.getKey());
                builder.append(':');
                builder.append(resource.getLocalName());
                return builder.toString();
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(iriValue);
        builder.append('>');
        return builder.toString();
    }

    public static String bnode(BNode bnode) {
        StringBuilder builder = new StringBuilder();
        builder.append("_:");
        builder.append(bnode.getID());
        return builder.toString();
    }

    public static String literal(Context context, Literal literal) {
        String label = literal.getLabel();
        URI datatype = literal.getDatatype();
        if (XMLSchema.INTEGER.equals((Object)datatype) || XMLSchema.DECIMAL.equals((Object)datatype) || XMLSchema.DOUBLE.equals((Object)datatype) || XMLSchema.BOOLEAN.equals((Object)datatype)) {
            try {
                return XMLDatatypeUtil.normalize((String)label, (URI)datatype);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        StringBuilder builder = new StringBuilder();
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            builder.append("\"\"\"");
            builder.append(TurtleUtil.encodeLongString((String)label));
            builder.append("\"\"\"");
        } else {
            builder.append("\"");
            builder.append(TurtleUtil.encodeString((String)label));
            builder.append("\"");
        }
        if (Literals.isLanguageLiteral((Literal)literal)) {
            builder.append("@");
            builder.append(literal.getLanguage());
        } else if (!XMLSchema.STRING.equals((Object)datatype)) {
            builder.append("^^");
            builder.append(TurtleElements.iri(context, datatype));
        }
        return builder.toString();
    }

    public static String value(Context context, Value value) {
        if (value instanceof URI) {
            return TurtleElements.iri(context, (URI)value);
        }
        if (value instanceof BNode) {
            return TurtleElements.bnode((BNode)value);
        }
        return TurtleElements.literal(context, (Literal)value);
    }

    public static String resource(Resource id) {
        StringBuilder builder = new StringBuilder();
        if (id == null) {
            return "null";
        }
        if (id instanceof URI) {
            builder.append('<');
            builder.append(id.stringValue());
            builder.append('>');
        } else {
            builder.append("_:");
            builder.append(id.stringValue());
        }
        return builder.toString();
    }
}

