/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.vocab;

import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.ShapePropertyPair;
import io.konig.shacl.ShapeReasoner;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XOWL {
    private static Logger logger = LoggerFactory.getLogger(XOWL.class);
    public static final URI Stable = new URIImpl("http://schema.pearson.com/ns/xowl/termStatus/statusStable");
    public static final URI Experimental = new URIImpl("http://schema.pearson.com/ns/xowl/termStatus/statusExperimental");
    public static final URI Invalid = new URIImpl("http://schema.pearson.com/ns/xowl/termStatus/statusInvalid");
    public static final URI Superseded = new URIImpl("http://schema.pearson.com/ns/xowl/termStatus/statusSuperseded");
    public static final URI Retired = new URIImpl("http://schema.pearson.com/ns/xowl/termStatus/statusRetired");

    public static void classifyProperties(OwlReasoner owlReasoner, ShapeReasoner shapeReasoner) {
        Set<Vertex> vertices = owlReasoner.allRdfAndOwlProperties();
        HashSet<URI> properties = new HashSet<URI>();
        for (Vertex v : vertices) {
            if (!(v.getId() instanceof URI)) continue;
            properties.add((URI)v.getId());
        }
        properties.addAll(shapeReasoner.predicates());
        for (URI p : properties) {
            URI range;
            Vertex v = owlReasoner.getGraph().vertex((Resource)p);
            if (v.hasProperty(RDF.TYPE, (Value)OWL.DATATYPEPROPERTY) || v.hasProperty(RDF.TYPE, (Value)OWL.OBJECTPROPERTY)) continue;
            boolean isDatatype = false;
            boolean isObject = false;
            ShapeReasoner.PropertyInfo info = shapeReasoner.getPropertyInfo(p);
            if (info != null) {
                for (ShapePropertyPair pair : info.getUsage()) {
                    PropertyConstraint constraint = pair.getPropertyConstraint();
                    if (!isDatatype) {
                        boolean bl = isDatatype = constraint.getDatatype() != null;
                    }
                    if (isObject) continue;
                    isObject = constraint.getValueClass() != null || constraint.getShape() != null;
                }
            }
            if ((range = v.getURI(RDFS.RANGE)) != null) {
                if (owlReasoner.isSubclassOfLiteral((Resource)range)) {
                    isDatatype = true;
                } else {
                    isObject = true;
                }
            }
            if (isDatatype && isObject) {
                logger.warn("Cannot classify property: " + p.stringValue());
                continue;
            }
            if (isDatatype) {
                owlReasoner.getGraph().edge((Resource)p, RDF.TYPE, (Value)OWL.DATATYPEPROPERTY);
                logger.info("classifyProperty: <{}> rdf:type owl:DatatypeProperty", (Object)p.stringValue());
                continue;
            }
            owlReasoner.getGraph().edge((Resource)p, RDF.TYPE, (Value)OWL.OBJECTPROPERTY);
            logger.info("classifyProperty: <{}> rdf:type owl:ObjectProperty", (Object)p.stringValue());
        }
    }
}

