/*
 * Decompiled with CFR 0.152.
 */
package io.konig.datasource;

import io.konig.annotation.RdfProperty;
import io.konig.core.pojo.ConditionalEmbeddable;
import io.konig.core.util.IriTemplate;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSourceManager;
import io.konig.lineage.DatasourceProperty;
import io.konig.lineage.DatasourcePropertyPath;
import io.konig.shacl.ShapeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class DataSource
implements ConditionalEmbeddable {
    private Resource id;
    private String identifier;
    private Set<URI> type = new LinkedHashSet<URI>();
    private IriTemplate iriTemplate;
    private List<URI> isPartOf;
    private Set<URI> etlPattern;
    private List<DatasourceProperty> datasourceProperty;

    public boolean isA(URI type) {
        return this.type.contains(type) || Konig.DataSource.equals((Object)type);
    }

    @RdfProperty(value="http://purl.org/dc/terms/identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @RdfProperty(value="http://purl.org/dc/terms/identifier")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void addType(URI type) {
        this.type.add(type);
    }

    @RdfProperty(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    public Set<URI> getType() {
        return this.type;
    }

    public Resource getId() {
        return this.id;
    }

    public void setId(Resource id) {
        this.id = id;
        if (id != null) {
            DataSourceManager.getInstance().add(this);
        }
    }

    @RdfProperty(value="http://www.konig.io/ns/core/iriTemplate")
    public IriTemplate getIriTemplate() {
        return this.iriTemplate;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/iriTemplate")
    public void setIriTemplate(IriTemplate iriTemplate) {
        this.iriTemplate = iriTemplate;
    }

    @RdfProperty(value="http://schema.org/isPartOf")
    public List<URI> getIsPartOf() {
        return this.isPartOf == null ? Collections.emptyList() : this.isPartOf;
    }

    public void addIsPartOf(URI systemId) {
        if (this.isPartOf == null) {
            this.isPartOf = new ArrayList<URI>();
        }
        if (!this.isPartOf.contains(systemId)) {
            this.isPartOf.add(systemId);
        }
    }

    public int hashCode() {
        return this.id == null ? super.hashCode() : this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof DataSource) {
            return this.id.equals(((DataSource)other).getId());
        }
        return false;
    }

    @Override
    public boolean isEmbeddabled() {
        return true;
    }

    public void addDatasourceProperty(DatasourceProperty p) {
        if (this.datasourceProperty == null) {
            this.datasourceProperty = new ArrayList<DatasourceProperty>();
        }
        this.datasourceProperty.add(p);
        p.setPropertySource(this);
    }

    public DatasourceProperty findPropertyByPath(DatasourcePropertyPath path) {
        for (DatasourceProperty p : this.getDatasourceProperty()) {
            if (!p.getPropertyPath().equals(path)) continue;
            return p;
        }
        return null;
    }

    public DatasourceProperty findPropertyByPredicate(URI predicate) {
        for (DatasourceProperty p : this.getDatasourceProperty()) {
            URI value;
            if (p.getPropertyPath().size() != 1 || !(value = (URI)p.getPropertyPath().get(0)).equals((Object)predicate)) continue;
            return p;
        }
        return null;
    }

    public List<DatasourceProperty> getDatasourceProperty() {
        return this.datasourceProperty == null ? Collections.emptyList() : this.datasourceProperty;
    }

    public void addEtlPattern(URI pattern) {
        if (this.etlPattern == null) {
            this.etlPattern = new LinkedHashSet<URI>();
        }
        this.etlPattern.add(pattern);
    }

    @RdfProperty(value="http://www.konig.io/ns/core/etlPattern")
    public Set<URI> getEtlPattern() {
        return this.etlPattern == null ? Collections.emptySet() : this.etlPattern;
    }

    public static class Builder {
        private ShapeBuilder shapeBuilder;
        private DataSource ds;

        public Builder(ShapeBuilder shapeBuilder) {
            this.shapeBuilder = shapeBuilder;
            this.ds = new DataSource();
        }

        public Builder id(Resource id) {
            this.ds.setId(id);
            return this;
        }

        public Builder id(String idValue) {
            this.ds.setId((Resource)new URIImpl(idValue));
            return this;
        }

        public Builder type(URI type) {
            this.ds.addType(type);
            return this;
        }

        public ShapeBuilder endDataSource() {
            this.shapeBuilder.peekShape().addShapeDataSource(this.ds);
            return this.shapeBuilder;
        }
    }
}

