/*
 * Decompiled with CFR 0.152.
 */
package io.konig.datasource;

import io.konig.annotation.RdfProperty;
import io.konig.core.KonigException;
import io.konig.core.project.ProjectFile;
import io.konig.core.util.StringUtil;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import org.openrdf.model.URI;

public abstract class TableDataSource
extends DataSource {
    private ProjectFile ddlFile;
    private ProjectFile transformFile;

    public abstract String getDdlFileName();

    public abstract String getTransformFileName();

    public abstract String getTableIdentifier();

    public abstract String getSqlDialect();

    public abstract String getUniqueIdentifier();

    public abstract String getQualifiedTableName();

    public abstract TableDataSource generateAssociationTable(Shape var1, URI var2);

    @RdfProperty(value="http://www.konig.io/ns/core/ddlFile")
    public ProjectFile getDdlFile() {
        return this.ddlFile;
    }

    public void setDdlFile(ProjectFile file) {
        this.ddlFile = file;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/transformFile")
    public ProjectFile getTransformFile() {
        return this.transformFile;
    }

    public void setTransformFile(ProjectFile file) {
        this.transformFile = file;
    }

    protected String associationTableName(Shape subjectShape, URI predicate) {
        URI targetClass = subjectShape.getTargetClass();
        if (targetClass == null) {
            throw new KonigException("targetClass must be defined for Shape " + subjectShape.getId().stringValue());
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.SNAKE_CASE(targetClass.getLocalName()));
        builder.append('_');
        builder.append(StringUtil.SNAKE_CASE(predicate.getLocalName()));
        builder.append("_ASSOC");
        return builder.toString();
    }
}

