/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.BinaryOperator;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.NumericExpression;
import io.konig.formula.RelationalExpression;

public class BinaryRelationalExpression
extends AbstractFormula
implements RelationalExpression {
    private BinaryOperator operator;
    private NumericExpression left;
    private NumericExpression right;

    public BinaryRelationalExpression(BinaryOperator operator, NumericExpression left, NumericExpression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public BinaryRelationalExpression clone() {
        return new BinaryRelationalExpression(this.operator, this.left.clone(), this.right == null ? null : this.right.clone());
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public NumericExpression getLeft() {
        return this.left;
    }

    public NumericExpression getRight() {
        return this.right;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        this.left.print(out);
        if (this.operator != null) {
            this.operator.print(out);
            this.right.print(out);
        }
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        this.left.dispatch(visitor);
        if (this.operator != null) {
            this.operator.dispatch(visitor);
            this.right.dispatch(visitor);
        }
        visitor.exit(this);
    }

    @Override
    public BinaryRelationalExpression asBinaryRelationalExpression() {
        return this;
    }
}

