/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.Expression;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.WhenThenClause;
import java.util.ArrayList;
import java.util.List;

public class CaseStatement
extends AbstractFormula
implements PrimaryExpression {
    private Expression caseCondition;
    private List<WhenThenClause> whenThenList;
    private Expression elseClause;

    public CaseStatement(Expression caseCondition, List<WhenThenClause> whenThenList, Expression elseClause) {
        this.caseCondition = caseCondition;
        this.whenThenList = whenThenList;
        this.elseClause = elseClause;
    }

    @Override
    public CaseStatement clone() {
        Expression otherCaseCondition = this.caseCondition == null ? null : this.caseCondition.clone();
        List<WhenThenClause> otherWhenThenList = this.whenThenList == null ? null : this.clone(this.whenThenList);
        Expression otherElseClause = this.elseClause == null ? null : this.elseClause.clone();
        return new CaseStatement(otherCaseCondition, otherWhenThenList, otherElseClause);
    }

    private List<WhenThenClause> clone(List<WhenThenClause> list) {
        ArrayList<WhenThenClause> result = new ArrayList<WhenThenClause>();
        for (WhenThenClause c : list) {
            result.add(c.clone());
        }
        return result;
    }

    public Expression getCaseCondition() {
        return this.caseCondition;
    }

    public List<WhenThenClause> getWhenThenList() {
        return this.whenThenList;
    }

    public Expression getElseClause() {
        return this.elseClause;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        out.setSuppressContext(true);
        out.println();
        out.pushIndent();
        out.indent();
        out.print("CASE");
        if (this.caseCondition != null) {
            out.print(' ');
            this.caseCondition.print(out);
        }
        out.pushIndent();
        for (WhenThenClause clause : this.whenThenList) {
            clause.print(out);
        }
        if (this.elseClause != null) {
            out.println();
            out.indent();
            out.print("ELSE ");
            this.elseClause.print(out);
        }
        out.popIndent();
        out.println();
        out.indent();
        out.print("END");
        out.popIndent();
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        for (WhenThenClause whenThen : this.whenThenList) {
            whenThen.dispatch(visitor);
        }
        if (this.elseClause != null) {
            this.elseClause.dispatch(visitor);
        }
        visitor.exit(this);
    }
}

