/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.Term;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.PathTerm;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class CurieValue
extends AbstractFormula
implements PathTerm {
    private String namespacePrefix;
    private String localName;
    private Context context;

    public CurieValue(Context context, String namespacePrefix, String localName) {
        this.namespacePrefix = namespacePrefix;
        this.localName = localName;
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public CurieValue clone() {
        return new CurieValue(this.context, this.namespacePrefix, this.localName);
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        out.print(this.namespacePrefix);
        out.print(':');
        out.print(this.localName);
    }

    @Override
    public URI getIri() {
        Term term = this.context.getTerm(this.namespacePrefix);
        if (term == null) {
            throw new KonigException("Cannot resolve namespace prefix: " + this.namespacePrefix);
        }
        String namespace = term.getExpandedIdValue();
        if (!(namespace.endsWith("/") || namespace.endsWith("#") || namespace.endsWith(":"))) {
            namespace = namespace + "/";
        }
        StringBuilder builder = new StringBuilder(namespace);
        builder.append(this.localName);
        return new URIImpl(builder.toString());
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }
}

