/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.Direction;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import io.konig.formula.VariableTerm;
import org.openrdf.model.URI;

public class DirectionStep
extends AbstractFormula
implements PathStep {
    private Direction direction;
    private PathTerm term;

    public DirectionStep(Direction direction, PathTerm term) {
        this.direction = direction;
        this.term = term;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public PathTerm getTerm() {
        return this.term;
    }

    @Override
    public DirectionStep clone() {
        return new DirectionStep(this.direction, this.term);
    }

    @Override
    public void print(PrettyPrintWriter out) {
        if (!(this.term instanceof VariableTerm)) {
            this.direction.print(out);
        }
        this.term.print(out);
    }

    public boolean equals(Object other) {
        if (other instanceof DirectionStep) {
            DirectionStep dir = (DirectionStep)other;
            return dir.getDirection() == this.direction && dir.getTerm().getIri().equals((Object)this.term.getIri());
        }
        return false;
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        this.direction.dispatch(visitor);
        this.term.dispatch(visitor);
        visitor.exit(this);
    }

    @Override
    public URI getIri() {
        return this.getTerm().getIri();
    }
}

