/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.Term;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.BinaryRelationalExpression;
import io.konig.formula.ConditionalAndExpression;
import io.konig.formula.FormulaParser;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.GeneralAdditiveExpression;
import io.konig.formula.MultiplicativeExpression;
import io.konig.formula.NumericExpression;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.UnaryExpression;
import io.konig.formula.ValueLogical;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.rio.RDFParseException;

public abstract class Expression
extends AbstractFormula {
    protected List<ConditionalAndExpression> orList;
    protected Context context;

    protected Expression(String text) {
        FormulaParser parser = new FormulaParser();
        try {
            Expression self = parser.expression(text);
            this.orList = self.getOrList();
            this.context = self.getContext();
        }
        catch (IOException | RDFParseException e) {
            throw new KonigException("Failed to parse Expression: " + text, e);
        }
    }

    protected Expression(Context context, List<ConditionalAndExpression> orList) {
        this.context = context;
        this.orList = orList;
    }

    public Expression() {
        this.orList = new ArrayList<ConditionalAndExpression>();
    }

    @Override
    public abstract Expression clone();

    protected Expression(Expression e) {
        this.context = e.context;
        this.orList = e.orList;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void add(ConditionalAndExpression expr) {
        this.orList.add(expr);
    }

    public List<ConditionalAndExpression> getOrList() {
        return this.orList;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        Context lastWrittenContext = out.getLastWrittenContext();
        if (this.context != null && !out.isSuppressContext() && this.context != lastWrittenContext) {
            out.setLastWrittenContext(this.context);
            this.context.compile();
            this.printContext(out, this.context.asList());
        }
        this.printOrList(out);
        out.setLastWrittenContext(lastWrittenContext);
    }

    public String getText() {
        StringWriter buffer = new StringWriter();
        PrettyPrintWriter out = new PrettyPrintWriter(buffer);
        this.printOrList(out);
        out.close();
        return buffer.toString();
    }

    protected void printOrList(PrettyPrintWriter out) {
        String operator = "";
        for (ConditionalAndExpression e : this.orList) {
            out.print(operator);
            e.print(out);
            operator = " || ";
        }
    }

    private void printContext(PrettyPrintWriter out, List<Term> termList) {
        if (!termList.isEmpty()) {
            out.println();
            this.printPrefixes(out, termList);
            this.printTerms(out, termList);
            out.println();
        }
    }

    private void printTerms(PrettyPrintWriter out, List<Term> termList) {
        for (Term term : termList) {
            if (term.getKind() == Term.Kind.NAMESPACE) continue;
            out.print("@term ");
            out.print(term.getKey());
            out.print(' ');
            if (term.getExpandedId().stringValue().equals(term.getId())) {
                out.print('<');
                out.print(term.getId());
                out.println('>');
                continue;
            }
            out.println(term.getId());
        }
    }

    private void printPrefixes(PrettyPrintWriter out, List<Term> termList) {
        for (Term term : termList) {
            char c;
            if (term.getKind() == Term.Kind.ANY && ((c = term.getId().charAt(term.getId().length() - 1)) == '/' || c == '#' || c == ':') && term.getExpandedId().stringValue().equals(term.getExpandedIdValue())) {
                term.setKind(Term.Kind.NAMESPACE);
            }
            if (term.getKind() != Term.Kind.NAMESPACE) continue;
            out.print("@prefix ");
            out.print(term.getKey());
            out.print(": <");
            out.print(term.getId());
            out.println("> .");
        }
    }

    public Value toValue() {
        String text = this.toString();
        return new LiteralImpl(text);
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        for (ConditionalAndExpression and : this.orList) {
            and.dispatch(visitor);
        }
        this.doDispatch(visitor);
        visitor.exit(this);
    }

    protected void doDispatch(FormulaVisitor visitor) {
    }

    @Override
    public BinaryRelationalExpression asBinaryRelationalExpression() {
        ValueLogical value;
        ConditionalAndExpression and;
        List<ValueLogical> andList;
        List<ConditionalAndExpression> orList = this.getOrList();
        if (orList.size() == 1 && (andList = (and = orList.get(0)).getAndList()).size() == 1 && (value = andList.get(0)) instanceof BinaryRelationalExpression) {
            return (BinaryRelationalExpression)value;
        }
        return null;
    }

    @Override
    public PrimaryExpression asPrimaryExpression() {
        UnaryExpression unary;
        MultiplicativeExpression mult;
        GeneralAdditiveExpression additive;
        NumericExpression left;
        BinaryRelationalExpression binary;
        ValueLogical value;
        ConditionalAndExpression and;
        List<ValueLogical> andList;
        List<ConditionalAndExpression> orList = this.getOrList();
        if (orList.size() == 1 && (andList = (and = orList.get(0)).getAndList()).size() == 1 && (value = andList.get(0)) instanceof BinaryRelationalExpression && (binary = (BinaryRelationalExpression)value).getRight() == null && (left = binary.getLeft()) instanceof GeneralAdditiveExpression && ((additive = (GeneralAdditiveExpression)left).getAddendList() == null || additive.getAddendList().isEmpty()) && ((mult = additive.getLeft()).getMultiplierList() == null || mult.getMultiplierList().isEmpty()) && (unary = mult.getLeft()).getOperator() == null) {
            return unary.getPrimary();
        }
        return null;
    }

    public GeneralAdditiveExpression asAdditiveExpression() {
        NumericExpression left;
        BinaryRelationalExpression binary;
        ValueLogical value;
        ConditionalAndExpression and;
        List<ValueLogical> andList;
        List<ConditionalAndExpression> orList = this.getOrList();
        if (orList.size() == 1 && (andList = (and = orList.get(0)).getAndList()).size() == 1 && (value = andList.get(0)) instanceof BinaryRelationalExpression && (binary = (BinaryRelationalExpression)value).getRight() == null && (left = binary.getLeft()) instanceof GeneralAdditiveExpression) {
            return (GeneralAdditiveExpression)left;
        }
        return null;
    }

    public NumericExpression asNumericExpression() {
        BinaryRelationalExpression binary;
        ValueLogical value;
        ConditionalAndExpression and;
        List<ValueLogical> andList;
        List<ConditionalAndExpression> orList = this.getOrList();
        if (orList.size() == 1 && (andList = (and = orList.get(0)).getAndList()).size() == 1 && (value = andList.get(0)) instanceof BinaryRelationalExpression && (binary = (BinaryRelationalExpression)value).getRight() == null) {
            return binary.getLeft();
        }
        return null;
    }
}

