/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Path;
import io.konig.core.path.HasStep;
import io.konig.core.path.InStep;
import io.konig.core.path.OutStep;
import io.konig.core.path.PathImpl;
import io.konig.core.path.Step;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.Expression;
import io.konig.formula.Formula;
import io.konig.formula.HasPathStep;
import io.konig.formula.IriValue;
import io.konig.formula.LiteralFormula;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import io.konig.formula.PredicateObjectList;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.VariableTerm;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class Formula2PathTranslator {
    private static final Formula2PathTranslator INSTANCE = new Formula2PathTranslator();

    public static Formula2PathTranslator getInstance() {
        return INSTANCE;
    }

    public Path toPath(Formula formula) {
        if (formula instanceof Expression) {
            return this.fromExpression((Expression)formula);
        }
        return null;
    }

    private Path fromExpression(Expression e) {
        PathImpl result = null;
        PrimaryExpression pe = e.asPrimaryExpression();
        if (pe instanceof PathExpression) {
            PathExpression p = (PathExpression)pe;
            result = new PathImpl();
            result.setContext(e.getContext());
            for (PathStep s : p.getStepList()) {
                Step step = this.step(s);
                if (step == null) {
                    return null;
                }
                step = this.step(s);
                if (step == null) {
                    return null;
                }
                result.add(this.step(s));
            }
        }
        return result;
    }

    private Step step(PathStep s) {
        if (s instanceof DirectionStep) {
            return this.directionStep((DirectionStep)s);
        }
        if (s instanceof HasPathStep) {
            return this.hasStep((HasPathStep)s);
        }
        return null;
    }

    private HasStep hasStep(HasPathStep s) {
        HasStep has = new HasStep();
        for (PredicateObjectList pol : s.getConstraints()) {
            URI predicate = pol.getVerb().getIri();
            for (Expression e : pol.getObjectList().getExpressions()) {
                PrimaryExpression primary = e.asPrimaryExpression();
                if (primary == null) {
                    return null;
                }
                Literal value = null;
                if (primary instanceof LiteralFormula) {
                    LiteralFormula literal = (LiteralFormula)primary;
                    value = literal.getLiteral();
                } else if (primary instanceof PathExpression) {
                    PathTerm term;
                    DirectionStep dirStep;
                    PathStep pathStep;
                    PathExpression path = (PathExpression)primary;
                    List<PathStep> stepList = path.getStepList();
                    if (stepList.size() == 1 && (pathStep = stepList.get(0)) instanceof DirectionStep && (dirStep = (DirectionStep)pathStep).getDirection() == Direction.OUT && (term = dirStep.getTerm()) instanceof IriValue) {
                        value = term.getIri();
                    }
                } else if (primary instanceof IriValue) {
                    IriValue iriValue = (IriValue)primary;
                    value = iriValue.getIri();
                }
                if (value != null) {
                    has.add(predicate, (Value)value);
                    continue;
                }
                return null;
            }
        }
        return has;
    }

    private Step directionStep(DirectionStep s) {
        PathTerm term = s.getTerm();
        if (term instanceof VariableTerm) {
            return new OutStep(term.getIri());
        }
        switch (s.getDirection()) {
            case IN: {
                return this.inStep(s);
            }
            case OUT: {
                return this.outStep(s);
            }
        }
        return null;
    }

    private Step outStep(DirectionStep s) {
        URI predicate = this.predicate(s);
        if (predicate == null) {
            return null;
        }
        return new OutStep(predicate);
    }

    private Step inStep(DirectionStep s) {
        URI predicate = this.predicate(s);
        if (predicate == null) {
            return null;
        }
        return new InStep(predicate);
    }

    private URI predicate(DirectionStep s) {
        return s.getTerm().getIri();
    }
}

