/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.formula.BinaryOperator;
import io.konig.formula.BinaryRelationalExpression;
import io.konig.formula.ConditionalOrExpression;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.Expression;
import io.konig.formula.FormulaConsumer;
import io.konig.formula.FullyQualifiedIri;
import io.konig.formula.FunctionExpression;
import io.konig.formula.FunctionModel;
import io.konig.formula.IfFunction;
import io.konig.formula.LiteralFormula;
import io.konig.formula.LocalNameTerm;
import io.konig.formula.NumericExpression;
import io.konig.formula.NumericExpressionConsumer;
import io.konig.formula.PathExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.ShapeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

public class FormulaBuilder
implements FormulaConsumer {
    private ShapeBuilder.PropertyBuilder propertyBuilder;
    private QuantifiedExpression formula;

    public FormulaBuilder() {
    }

    public ShapeBuilder.PropertyBuilder endFormula() {
        QuantifiedExpression q = this.getFormula();
        this.propertyBuilder.getPropertyConstraint().setFormula(q);
        return this.propertyBuilder;
    }

    public FormulaBuilder(ShapeBuilder.PropertyBuilder propertyBuilder) {
        this.propertyBuilder = propertyBuilder;
    }

    public PathBuilder<FormulaBuilder> beginPath() {
        return new PathBuilder<FormulaBuilder>(this);
    }

    public FunctionBuilder beginFunction(String functionName) {
        return new FunctionBuilder(this, functionName);
    }

    public FormulaBuilder iri(String value) {
        FullyQualifiedIri id = new FullyQualifiedIri((URI)new URIImpl(value));
        this.formula = QuantifiedExpression.wrap(id);
        return this;
    }

    public QuantifiedExpression getFormula() {
        return this.formula;
    }

    public IfFunctionBuilder<FormulaBuilder> beginIf() {
        return new IfFunctionBuilder<FormulaBuilder>(this);
    }

    @Override
    public void setFormula(QuantifiedExpression formula) {
        this.formula = formula;
    }

    public static class FunctionBuilder
    implements FormulaConsumer {
        private String functionName;
        private FormulaBuilder formulaBuilder;
        private List<Expression> argList = new ArrayList<Expression>();

        public FunctionBuilder(FormulaBuilder formulaBuilder, String functionName) {
            this.formulaBuilder = formulaBuilder;
            this.functionName = functionName;
        }

        public FunctionBuilder literal(String value) {
            LiteralFormula literal = new LiteralFormula((Literal)new LiteralImpl(value));
            ConditionalOrExpression e = ConditionalOrExpression.wrap(literal);
            this.argList.add(e);
            return this;
        }

        public PathBuilder<FunctionBuilder> beginPath() {
            return new PathBuilder<FunctionBuilder>(this);
        }

        public FormulaBuilder endFunction() {
            FunctionExpression function = new FunctionExpression(FunctionModel.fromName(this.functionName), this.argList);
            QuantifiedExpression formula = QuantifiedExpression.wrap(function);
            this.formulaBuilder.setFormula(formula);
            return this.formulaBuilder;
        }

        @Override
        public void setFormula(QuantifiedExpression formula) {
            this.argList.add(formula);
        }
    }

    public static class BasicPathBuilder
    extends PathBuilder<DummyFormulaConsumer> {
    }

    public static class DummyFormulaConsumer
    implements FormulaConsumer {
        @Override
        public void setFormula(QuantifiedExpression formula) {
        }
    }

    public static class PathBuilder<T extends FormulaConsumer> {
        private T formulaConsumer;
        private List<DirectedPredicate> predicateList;

        public PathBuilder() {
        }

        public PathBuilder(T formulaConsumer) {
            this.formulaConsumer = formulaConsumer;
        }

        public PathBuilder<T> out(URI predicate) {
            this.predicateList().add(new DirectedPredicate(Direction.OUT, predicate));
            return this;
        }

        private List<DirectedPredicate> predicateList() {
            if (this.predicateList == null) {
                this.predicateList = new ArrayList<DirectedPredicate>();
            }
            return this.predicateList;
        }

        public PathBuilder<T> in(URI predicate) {
            this.predicateList().add(new DirectedPredicate(Direction.IN, predicate));
            return this;
        }

        public PathBuilder<T> pop() {
            List<DirectedPredicate> list = this.predicateList();
            list.remove(list.size() - 1);
            return this;
        }

        public QuantifiedExpression build() {
            PathExpression path = new PathExpression();
            QuantifiedExpression formula = QuantifiedExpression.wrap(path);
            BasicContext context = new BasicContext(null);
            formula.setContext(context);
            for (DirectedPredicate e : this.predicateList()) {
                URI predicate = e.getPredicate();
                context.add(new Term(predicate.getLocalName(), predicate.stringValue()));
                DirectionStep step = new DirectionStep(e.getDirection(), new LocalNameTerm(context, predicate.getLocalName()));
                path.add(step);
            }
            return formula;
        }

        public T endPath() {
            QuantifiedExpression formula = this.build();
            this.formulaConsumer.setFormula(formula);
            return this.formulaConsumer;
        }
    }

    public static class WhenFalseBuilder<T extends FormulaConsumer>
    extends FormulaBuilder {
        private IfFunctionBuilder<T> ifFunction;

        public WhenFalseBuilder(IfFunctionBuilder<T> ifFunction) {
            this.ifFunction = ifFunction;
        }

        public IfFunctionBuilder<T> endWhenFalse() {
            this.ifFunction.setWhenFalse(this.getFormula());
            return this.ifFunction;
        }
    }

    public static class WhenTrueBuilder<T extends FormulaConsumer>
    extends FormulaBuilder {
        private IfFunctionBuilder<T> ifFunction;

        public WhenTrueBuilder(IfFunctionBuilder<T> ifFunction) {
            this.ifFunction = ifFunction;
        }

        public IfFunctionBuilder<T> endWhenTrue() {
            this.ifFunction.setWhenTrue(this.getFormula());
            return this.ifFunction;
        }
    }

    public static class IfConditionBuilder<T extends FormulaConsumer>
    extends FormulaBuilder {
        private IfFunctionBuilder<T> ifFunction;

        public IfConditionBuilder(IfFunctionBuilder<T> ifFunction) {
            this.ifFunction = ifFunction;
        }

        public IfFunctionBuilder<T> endCondition() {
            this.ifFunction.setCondition(this.getFormula());
            return this.ifFunction;
        }

        public BinaryRelationBuilder<IfConditionBuilder<T>> beginEquals() {
            return new BinaryRelationBuilder<IfConditionBuilder<T>>(this, BinaryOperator.EQUALS);
        }
    }

    public static class IfFunctionBuilder<T extends FormulaConsumer> {
        private T formulaConsumer;
        private Expression condition;
        private Expression whenTrue;
        private Expression whenFalse;

        public IfFunctionBuilder(T formulaConsumer) {
            this.formulaConsumer = formulaConsumer;
        }

        public IfConditionBuilder<T> beginCondition() {
            return new IfConditionBuilder(this);
        }

        public WhenTrueBuilder<T> beginWhenTrue() {
            return new WhenTrueBuilder(this);
        }

        public T endIf() {
            IfFunction func = new IfFunction(this.condition, this.whenTrue, this.whenFalse);
            this.formulaConsumer.setFormula(QuantifiedExpression.wrap(func));
            return this.formulaConsumer;
        }

        void setFormulaConsumer(T formulaConsumer) {
            this.formulaConsumer = formulaConsumer;
        }

        void setCondition(Expression condition) {
            this.condition = condition;
        }

        void setWhenTrue(Expression whenTrue) {
            this.whenTrue = whenTrue;
        }

        void setWhenFalse(Expression whenFalse) {
            this.whenFalse = whenFalse;
        }
    }

    public static class NumericExpressionBuilder<T>
    extends FormulaBuilder {
        private NumericExpressionConsumer numericConsumer;
        private T formulaConsumer;

        public NumericExpressionBuilder(NumericExpressionConsumer numericConsumer, T formulaConsumer) {
            this.numericConsumer = numericConsumer;
            this.formulaConsumer = formulaConsumer;
        }

        protected T end() {
            this.numericConsumer.setNumericExpression(this.getFormula().asNumericExpression());
            return this.formulaConsumer;
        }
    }

    public static class RightNumericBuilder<T>
    extends NumericExpressionBuilder<T> {
        public RightNumericBuilder(NumericExpressionConsumer numericConsumer, T formulaConsumer) {
            super(numericConsumer, formulaConsumer);
        }

        public T endRight() {
            return this.end();
        }
    }

    public static class LeftNumericBuilder<T>
    extends NumericExpressionBuilder<T> {
        public LeftNumericBuilder(NumericExpressionConsumer numericConsumer, T formulaConsumer) {
            super(numericConsumer, formulaConsumer);
        }

        public T endLeft() {
            return this.end();
        }
    }

    public static class BinaryRelationBuilder<T extends FormulaConsumer> {
        private T formulaConsumer;
        private BinaryOperator operator;
        private NumericExpression left;
        private NumericExpression right;

        public BinaryRelationBuilder(T formulaConsumer, BinaryOperator operator) {
            this.formulaConsumer = formulaConsumer;
            this.operator = operator;
        }

        public T endEquals() {
            BinaryRelationalExpression binary = new BinaryRelationalExpression(this.operator, this.left, this.right);
            this.formulaConsumer.setFormula(QuantifiedExpression.wrap(binary));
            return this.formulaConsumer;
        }

        public LeftNumericBuilder<BinaryRelationBuilder<T>> beginLeft() {
            return new LeftNumericBuilder<BinaryRelationBuilder<T>>(new NumericExpressionConsumer(){

                @Override
                public void setNumericExpression(NumericExpression numeric) {
                    left = numeric;
                }
            }, this);
        }

        public RightNumericBuilder<BinaryRelationBuilder<T>> beginRight() {
            return new RightNumericBuilder<BinaryRelationBuilder<T>>(new NumericExpressionConsumer(){

                @Override
                public void setNumericExpression(NumericExpression numeric) {
                    right = numeric;
                }
            }, this);
        }

        void setLeft(NumericExpression left) {
            this.left = left;
        }

        void setRight(NumericExpression right) {
            this.right = right;
        }
    }

    private static class DirectedPredicate {
        private Direction direction;
        private URI predicate;

        public DirectedPredicate(Direction direction, URI predicate) {
            this.direction = direction;
            this.predicate = predicate;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public URI getPredicate() {
            return this.predicate;
        }
    }
}

