/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.LocalNameService;
import io.konig.core.Term;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import io.konig.formula.Addend;
import io.konig.formula.AdditiveExpression;
import io.konig.formula.AdditiveOperator;
import io.konig.formula.BareExpression;
import io.konig.formula.BinaryOperator;
import io.konig.formula.BinaryRelationalExpression;
import io.konig.formula.BoundFunction;
import io.konig.formula.BrackettedExpression;
import io.konig.formula.BuiltInCall;
import io.konig.formula.CaseStatement;
import io.konig.formula.ConditionalAndExpression;
import io.konig.formula.ConditionalExpression;
import io.konig.formula.ConditionalOrExpression;
import io.konig.formula.ContainmentOperator;
import io.konig.formula.CurieValue;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.Expression;
import io.konig.formula.ExpressionList;
import io.konig.formula.Factor;
import io.konig.formula.FullyQualifiedIri;
import io.konig.formula.FunctionExpression;
import io.konig.formula.FunctionModel;
import io.konig.formula.GeneralAdditiveExpression;
import io.konig.formula.HasPathStep;
import io.konig.formula.IfFunction;
import io.konig.formula.IriTemplateExpression;
import io.konig.formula.IriValue;
import io.konig.formula.ListRelationalExpression;
import io.konig.formula.LiteralFormula;
import io.konig.formula.LocalNameTerm;
import io.konig.formula.MultiplicativeExpression;
import io.konig.formula.MultiplicativeOperator;
import io.konig.formula.NumericExpression;
import io.konig.formula.ObjectList;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import io.konig.formula.PredicateObjectList;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.PropertyOracle;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.RelationalExpression;
import io.konig.formula.SetFunctionExpression;
import io.konig.formula.Triple;
import io.konig.formula.UnaryExpression;
import io.konig.formula.UnaryOperator;
import io.konig.formula.ValueLogical;
import io.konig.formula.VariableTerm;
import io.konig.formula.WhenThenClause;
import io.konig.rio.turtle.NamespaceMap;
import io.konig.rio.turtle.SeaTurtleParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class FormulaParser {
    private static final Set<String> KEYWORD = new HashSet<String>();
    private PropertyOracle propertyOracle;
    private LocalNameService localNameService;
    private NamespaceMap namespaceMap;

    public FormulaParser() {
    }

    public QuantifiedExpression quantifiedExpression(String formula, URI ... terms) throws RDFParseException, IOException {
        StringBuilder builder = new StringBuilder();
        for (URI term : terms) {
            builder.append("@term ");
            builder.append(term.getLocalName());
            builder.append(" <");
            builder.append(term.stringValue());
            builder.append(">\n");
        }
        builder.append(formula);
        return this.quantifiedExpression(builder.toString());
    }

    public FormulaParser(PropertyOracle propertyOracle) {
        this.propertyOracle = propertyOracle;
    }

    public FormulaParser(PropertyOracle propertyOracle, LocalNameService localNameService) {
        this.propertyOracle = propertyOracle;
        this.localNameService = localNameService;
    }

    public FormulaParser(PropertyOracle propertyOracle, LocalNameService localNameService, NamespaceMap nsMap) {
        this.propertyOracle = propertyOracle;
        this.localNameService = localNameService;
        this.namespaceMap = nsMap;
    }

    public PropertyOracle getPropertyOracle() {
        return this.propertyOracle;
    }

    public LocalNameService getLocalNameService() {
        return this.localNameService;
    }

    public NamespaceMap getNamespaceMap() {
        return this.namespaceMap;
    }

    public QuantifiedExpression quantifiedExpression(String text) throws RDFParseException, IOException {
        StringReader reader = new StringReader(text);
        return this.quantifiedExpression(reader);
    }

    public QuantifiedExpression quantifiedExpression(Reader reader) throws RDFParseException, IOException {
        Worker worker = new Worker(reader);
        worker.setDefaultNamespaceMap(this.namespaceMap);
        try {
            return worker.quantifiedExpression();
        }
        catch (RDFHandlerException e) {
            throw new KonigException(e);
        }
    }

    public Expression expression(String text) throws RDFParseException, IOException {
        StringReader reader = new StringReader(text);
        return this.expression(reader);
    }

    public Expression expression(Reader reader) throws RDFParseException, IOException {
        Worker worker = new Worker(reader);
        try {
            return worker.formula();
        }
        catch (RDFHandlerException e) {
            throw new KonigException(e);
        }
    }

    static {
        KEYWORD.add("IF");
        KEYWORD.add("COUNT");
        KEYWORD.add("SUM");
        KEYWORD.add("AVG");
        KEYWORD.add("DAY");
        KEYWORD.add("MONTH");
        KEYWORD.add("YEAR");
        KEYWORD.add("CONCAT");
        KEYWORD.add("STRPOS");
        KEYWORD.add("SUBSTR");
        KEYWORD.add("BOUND");
        KEYWORD.add("UNIX_TIME");
        KEYWORD.add("CASE");
        KEYWORD.add("WHEN");
        KEYWORD.add("THEN");
        KEYWORD.add("ELSE");
        KEYWORD.add("END");
        KEYWORD.add("DISTINCT");
        KEYWORD.add("IN");
        KEYWORD.add("NOT");
        KEYWORD.add("AND");
        KEYWORD.add("OR");
        KEYWORD.add("WHERE");
    }

    private class Worker
    extends SeaTurtleParser {
        private Worker(Reader reader) {
            this.initParse(reader, "");
        }

        private Expression formula() throws RDFParseException, IOException, RDFHandlerException {
            this.prologue();
            return this.expression();
        }

        private QuantifiedExpression quantifiedExpression() throws RDFParseException, IOException, RDFHandlerException {
            this.prologue();
            Expression e = this.expression();
            List<Triple> statementList = null;
            return new QuantifiedExpression(e, statementList);
        }

        private Expression expression() throws RDFParseException, IOException, RDFHandlerException {
            ConditionalOrExpression e = this.conditionalOrExpression();
            e.getContext().compile();
            return e;
        }

        private BareExpression expr() throws RDFParseException, RDFHandlerException, IOException {
            ConditionalOrExpression e = this.conditionalOrExpression();
            return new BareExpression(e);
        }

        private ConditionalOrExpression conditionalOrExpression() throws RDFParseException, IOException, RDFHandlerException {
            ConditionalOrExpression or = new ConditionalOrExpression();
            or.setContext(this.getContext());
            ConditionalAndExpression and = this.conditionalAndExpression();
            or.add(and);
            while ((and = this.tryConditionalAndExpression()) != null) {
                or.add(and);
            }
            return or;
        }

        private ConditionalAndExpression tryConditionalAndExpression() throws IOException, RDFParseException, RDFHandlerException {
            if (this.tryWord("WHERE")) {
                this.unread("WHERE");
                return null;
            }
            ConditionalAndExpression and = null;
            ValueLogical value = this.tryValueLogical();
            if (value != null) {
                and = new ConditionalAndExpression();
                and.add(value);
                this.skipSpace();
                while (this.tryWord("&&") || this.isWord("AND")) {
                    value = this.valueLogical();
                    and.add(value);
                }
            }
            return and;
        }

        private boolean isString(String text) throws IOException {
            int k;
            StringBuilder buffer = this.buffer();
            for (int i = 0; i < text.length(); i += Character.charCount(k)) {
                k = this.read();
                if (k < 0) {
                    return false;
                }
                buffer.appendCodePoint(k);
                int c = text.codePointAt(i);
                if (c == k) continue;
                this.unread(buffer.toString());
                return false;
            }
            this.unread(buffer.toString());
            return true;
        }

        private boolean isWord(String word) throws IOException {
            if (this.tryWord(word)) {
                int c = this.peek();
                if (!Character.isLetterOrDigit(c) && c != 95) {
                    return true;
                }
                this.unread(word);
            }
            return false;
        }

        private ValueLogical valueLogical() throws RDFParseException, IOException, RDFHandlerException {
            ValueLogical value = this.tryValueLogical();
            if (value == null) {
                this.fail("Expected ValueLogical");
            }
            return value;
        }

        private ValueLogical tryValueLogical() throws IOException, RDFParseException, RDFHandlerException {
            return this.tryRelationalExpression();
        }

        private RelationalExpression tryRelationalExpression() throws IOException, RDFParseException, RDFHandlerException {
            RelationalExpression e = null;
            NumericExpression left = this.tryNumericExpression();
            if (left != null) {
                e = this.tryListRelationalExpression(left);
                e = e != null ? e : ((e = this.tryConditionalExpression(left)) != null ? e : ((e = this.tryBinaryRelationalExpression(left)) != null ? e : null));
            }
            return e;
        }

        private RelationalExpression tryConditionalExpression(NumericExpression condition) throws IOException, RDFParseException, RDFHandlerException {
            this.skipSpace();
            int c = this.read();
            if (c == 63) {
                this.skipSpace();
                NumericExpression whenTrue = this.numericExpression();
                this.skipSpace();
                this.read(':');
                this.skipSpace();
                NumericExpression whenFalse = this.numericExpression();
                return new ConditionalExpression(condition, whenTrue, whenFalse);
            }
            this.unread(c);
            return null;
        }

        private ListRelationalExpression tryListRelationalExpression(NumericExpression left) throws IOException, RDFParseException, RDFHandlerException {
            ListRelationalExpression list = null;
            this.skipSpace();
            ContainmentOperator operator = null;
            if (this.tryWord("IN")) {
                this.assertWhitespace();
                operator = ContainmentOperator.IN;
            } else if (this.tryWord("NOT")) {
                this.assertWhitespace();
                if (!this.tryWord("IN")) {
                    this.fail("Expected 'IN'");
                }
                operator = ContainmentOperator.NOT_IN;
            }
            if (operator != null) {
                ExpressionList right = this.expressionList();
                list = new ListRelationalExpression(operator, left, right);
            }
            return list;
        }

        private ExpressionList expressionList() throws IOException, RDFParseException, RDFHandlerException {
            ExpressionList list = new ExpressionList();
            this.skipSpace();
            this.assertNext(40);
            this.skipSpace();
            Expression e = this.expression();
            list.add(e);
            while (true) {
                this.skipSpace();
                int c = this.read();
                if (c == 44) {
                    e = this.expression();
                    list.add(e);
                    continue;
                }
                if (c == 41) break;
                this.fail("Expected ',' or ')'");
            }
            return list;
        }

        private BinaryRelationalExpression tryBinaryRelationalExpression(NumericExpression left) throws IOException, RDFParseException, RDFHandlerException {
            BinaryRelationalExpression binary = null;
            if (left != null) {
                BinaryOperator operator = null;
                NumericExpression right = null;
                int c = this.read();
                switch (c) {
                    case 61: {
                        operator = BinaryOperator.EQUALS;
                        break;
                    }
                    case 60: {
                        operator = this.tryWord("=") ? BinaryOperator.LESS_THAN_OR_EQUAL : BinaryOperator.LESS_THAN;
                        break;
                    }
                    case 62: {
                        operator = this.tryWord("=") ? BinaryOperator.GREATER_THAN_OR_EQUAL : BinaryOperator.GREATER_THAN;
                        break;
                    }
                    case 33: {
                        BinaryOperator binaryOperator = operator = this.tryWord("=") ? BinaryOperator.NOT_EQUAL : null;
                    }
                }
                if (operator == null) {
                    this.unread(c);
                } else {
                    right = this.numericExpression();
                }
                binary = new BinaryRelationalExpression(operator, left, right);
            }
            return binary;
        }

        private NumericExpression numericExpression() throws RDFParseException, IOException, RDFHandlerException {
            NumericExpression numeric = this.tryNumericExpression();
            if (numeric == null) {
                this.fail("Expected a NumericExpression");
            }
            return numeric;
        }

        private NumericExpression tryNumericExpression() throws IOException, RDFParseException, RDFHandlerException {
            return this.tryAdditiveExpression();
        }

        private AdditiveExpression tryAdditiveExpression() throws IOException, RDFParseException, RDFHandlerException {
            GeneralAdditiveExpression expr = null;
            MultiplicativeExpression left = this.tryMultiplicativeExpression();
            if (left != null) {
                expr = new GeneralAdditiveExpression(left);
                while (true) {
                    this.skipSpace();
                    int c = this.read();
                    AdditiveOperator operator = null;
                    switch (c) {
                        case 43: {
                            operator = AdditiveOperator.PLUS;
                            break;
                        }
                        case 45: {
                            operator = AdditiveOperator.MINUS;
                        }
                    }
                    if (operator == null) {
                        this.unread(c);
                        break;
                    }
                    this.skipSpace();
                    MultiplicativeExpression right = this.multiplicativeExpression();
                    Addend addend = new Addend(operator, right);
                    expr.add(addend);
                }
            }
            return expr;
        }

        private MultiplicativeExpression multiplicativeExpression() throws RDFParseException, IOException, RDFHandlerException {
            MultiplicativeExpression mult = this.tryMultiplicativeExpression();
            if (mult == null) {
                this.fail("Expected MultiplicativeExpression");
            }
            return mult;
        }

        private MultiplicativeExpression tryMultiplicativeExpression() throws IOException, RDFParseException, RDFHandlerException {
            MultiplicativeExpression mult = null;
            UnaryExpression left = this.tryUnaryExpression();
            if (left != null) {
                mult = new MultiplicativeExpression(left);
                while (true) {
                    MultiplicativeOperator operator = null;
                    this.skipSpace();
                    int c = this.read();
                    switch (c) {
                        case 42: {
                            operator = MultiplicativeOperator.MULTIPLY;
                            break;
                        }
                        case 47: {
                            operator = MultiplicativeOperator.DIVIDE;
                        }
                    }
                    if (operator == null) {
                        this.unread(c);
                        break;
                    }
                    UnaryExpression right = this.unaryExpression();
                    mult.add(new Factor(operator, right));
                }
            }
            return mult;
        }

        private UnaryExpression unaryExpression() throws RDFParseException, IOException, RDFHandlerException {
            UnaryExpression unary = this.tryUnaryExpression();
            if (unary == null) {
                this.fail("Expected UnaryExpression");
            }
            return unary;
        }

        private UnaryExpression tryUnaryExpression() throws IOException, RDFParseException, RDFHandlerException {
            this.skipSpace();
            int c = this.read();
            UnaryOperator operator = null;
            if (c == 33) {
                int d = this.peek();
                if (d == 61) {
                    return null;
                }
                operator = UnaryOperator.NOT;
            } else {
                this.unread(c);
            }
            PrimaryExpression primary = this.tryPrimaryExpression();
            if (operator != null && primary == null) {
                this.fail("Expected PrimaryExpression");
            }
            return primary == null ? null : new UnaryExpression(operator, primary);
        }

        private PrimaryExpression tryPrimaryExpression() throws IOException, RDFParseException, RDFHandlerException {
            PrimaryExpression primary = null;
            primary = this.tryBrackettedExpression();
            primary = primary != null ? primary : ((primary = this.tryBuiltInCall()) != null ? primary : ((primary = this.tryCase()) != null ? primary : ((primary = this.tryLiteralFormula()) != null ? primary : ((primary = this.tryPath()) != null ? primary : ((primary = this.tryIri()) != null ? primary : null)))));
            return primary;
        }

        private PrimaryExpression tryIri() throws IOException, RDFParseException, RDFHandlerException {
            PrimaryExpression result = null;
            result = this.tryFullIri();
            return result != null ? result : ((result = this.tryCurieOrLocalName()) != null ? result : null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private PathTerm tryCurieOrLocalName() throws IOException, RDFParseException {
            int c = this.next();
            if (!Character.isLetter(c)) {
                this.unread(c);
                return null;
            }
            StringBuilder buffer = this.buffer();
            do {
                buffer.appendCodePoint(c);
            } while (Character.isLetterOrDigit(c = this.read()) || c == 95);
            String predicate = buffer.toString();
            if (c == 58) {
                String namespace;
                boolean ok;
                String prefix = predicate;
                c = this.read();
                if (!Character.isLetterOrDigit(c)) {
                    this.fail("Expected a letter after ':' in CURIE");
                    return null;
                }
                buffer = this.buffer();
                do {
                    buffer.appendCodePoint(c);
                } while (Character.isLetterOrDigit(c = this.read()) || c == 95);
                String localName = buffer.toString();
                this.unread(c);
                Context context = this.getContext();
                boolean bl = ok = context.getTerm(prefix) != null;
                if (!ok && this.namespaceMap != null && (namespace = this.namespaceMap.get(prefix)) != null) {
                    Term term = context.addTerm(prefix, namespace);
                    term.setKind(Term.Kind.NAMESPACE);
                    ok = true;
                }
                if (ok) return new CurieValue(this.getContext(), prefix, localName);
                throw new RDFParseException("Namespace not defined for prefix: " + prefix);
            }
            this.unread(c);
            if (KEYWORD.contains(predicate.toUpperCase())) {
                this.unread(predicate);
                return null;
            }
            String localName = predicate;
            Context context = this.getContext();
            Term term = context.getTerm(localName);
            if (term != null) return new LocalNameTerm(context, predicate);
            if (FormulaParser.this.localNameService == null) return new LocalNameTerm(context, predicate);
            Set<URI> iriOptions = FormulaParser.this.localNameService.lookupLocalName(localName);
            if (iriOptions.size() == 1) {
                URI id = iriOptions.iterator().next();
                term = new Term(localName, id.stringValue(), Term.Kind.ANY);
                context.add(term);
                return new LocalNameTerm(context, predicate);
            }
            if (iriOptions.isEmpty()) {
                String msg = MessageFormat.format("Local name not found: {0}", localName);
                this.fail(msg);
                return new LocalNameTerm(context, predicate);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("Local name \"");
            builder.append(localName);
            builder.append("\" is ambiguous.  Could be one of");
            Iterator<URI> iterator = iriOptions.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.fail(builder.toString());
                    return new LocalNameTerm(context, predicate);
                }
                URI iri = iterator.next();
                builder.append("\n   ");
                builder.append(iri.stringValue());
            }
        }

        private PrimaryExpression tryFullIri() throws RDFParseException, IOException, RDFHandlerException {
            if (this.isString("<http://") || this.isString("<https://") || this.isString("<urn:") || this.isString("<file:")) {
                String iriText = this.iriRef();
                if (iriText.indexOf(123) >= 0) {
                    Context context = this.getContext();
                    IriTemplate template = new IriTemplate(context, iriText);
                    if (this.namespaceMap != null && FormulaParser.this.localNameService != null) {
                        for (ValueFormat.Element element : template.toList()) {
                            if (element.getType() != ValueFormat.ElementType.VARIABLE) continue;
                            String text = element.getText();
                            int colon = text.indexOf(58);
                            if (colon > 0) {
                                String prefix = text.substring(0, colon);
                                String namespaceURI = this.namespaceMap.get(prefix);
                                if (namespaceURI == null) {
                                    throw new RDFHandlerException("namespace prefix not defined: " + prefix);
                                }
                                context.add(new Term(prefix, namespaceURI, Term.Kind.NAMESPACE));
                                String localName = text.substring(colon + 1);
                                context.addTerm(localName, text);
                                continue;
                            }
                            Set<URI> set = FormulaParser.this.localNameService.lookupLocalName(text);
                            if (set.size() > 1) {
                                StringBuilder builder = new StringBuilder();
                                builder.append("Local name '");
                                builder.append(text);
                                builder.append("' is ambiguous.  Possible values include: ");
                                for (URI uri : set) {
                                    builder.append("\n  ");
                                    builder.append(uri.stringValue());
                                }
                                throw new RDFHandlerException(builder.toString());
                            }
                            if (set.isEmpty()) {
                                throw new RDFHandlerException("Local name not known: " + text);
                            }
                            URI uri = set.iterator().next();
                            context.addTerm(text, uri.stringValue());
                        }
                    }
                    return new IriTemplateExpression(template);
                }
                return new FullyQualifiedIri((URI)new URIImpl(iriText));
            }
            return null;
        }

        private IfFunction tryIfFunction() throws IOException, RDFParseException, RDFHandlerException {
            this.skipSpace();
            if (this.tryCaseInsensitiveWord("IF") != null) {
                this.skipSpace();
                int c = this.read();
                if (c != 40) {
                    this.unread(c);
                } else {
                    this.skipSpace();
                    BareExpression condition = this.expr();
                    this.read(',');
                    BareExpression whenTrue = this.expr();
                    this.read(',');
                    BareExpression whenFalse = this.expr();
                    this.assertNext(41);
                    return new IfFunction(condition, whenTrue, whenFalse);
                }
            }
            return null;
        }

        private BuiltInCall tryBuiltInCall() throws IOException, RDFParseException, RDFHandlerException {
            BuiltInCall call = this.tryIfFunction();
            call = call != null ? call : ((call = this.trySetFunction(FunctionModel.SUM)) != null ? call : ((call = this.trySetFunction(FunctionModel.AVG)) != null ? call : ((call = this.trySetFunction(FunctionModel.COUNT)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.DAY)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.MONTH)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.YEAR)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.CONCAT)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.SUBSTR)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.STRPOS)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.UNIX_TIME)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.IRI)) != null ? call : ((call = this.tryGenericFunction(FunctionModel.STRIP_SPACES)) != null ? call : ((call = this.tryBoundFunction()) != null ? call : null)))))))))))));
            return call;
        }

        private SetFunctionExpression trySetFunction(FunctionModel model) throws IOException, RDFParseException, RDFHandlerException {
            this.skipSpace();
            String functionName = model.getName();
            String name = this.tryCaseInsensitiveWord(functionName);
            if (name != null) {
                int c = this.next();
                if (c != 40) {
                    this.unread(c);
                    this.unread(name);
                } else {
                    boolean distinct;
                    this.skipSpace();
                    boolean bl = distinct = this.tryCaseInsensitiveWord("DISTINCT") != null;
                    if (distinct) {
                        this.skipSpace();
                    }
                    List<Expression> argList = this.argList();
                    this.assertNext(41);
                    return new SetFunctionExpression(model, distinct, argList);
                }
            }
            return null;
        }

        private BoundFunction tryBoundFunction() throws IOException, RDFParseException, RDFHandlerException {
            if (this.tryWord("BOUND")) {
                int c = this.next();
                if (c != 40) {
                    this.unread(c);
                    this.unread("BOUND");
                } else {
                    PathExpression arg = this.tryPath();
                    if (arg == null) {
                        this.fail("Expected variable or path as argument to BOUND function");
                    }
                    this.assertNext(41);
                    return new BoundFunction(arg);
                }
            }
            return null;
        }

        private BuiltInCall tryGenericFunction(FunctionModel model) throws IOException, RDFParseException, RDFHandlerException {
            this.skipSpace();
            String functionName = model.getName();
            String name = this.tryCaseInsensitiveWord(functionName);
            if (name != null) {
                int c = this.next();
                if (c != 40) {
                    this.unread(c);
                    this.unread(name);
                } else {
                    this.skipSpace();
                    List<Expression> argList = this.argList();
                    this.assertNext(41);
                    return new FunctionExpression(model, argList);
                }
            }
            return null;
        }

        private CaseStatement tryCase() throws IOException, RDFParseException, RDFHandlerException {
            this.skipSpace();
            String name = this.tryCaseInsensitiveWord("CASE");
            if (name != null) {
                Expression caseCondition = null;
                this.skipSpace();
                String when = this.tryCaseInsensitiveWord("WHEN");
                if (when == null) {
                    caseCondition = this.expression();
                } else {
                    this.unread(when);
                }
                List<WhenThenClause> whenThenList = this.whenThenList();
                Expression elseClause = null;
                if (this.tryCaseInsensitiveWord("ELSE") != null) {
                    elseClause = this.expression();
                }
                this.skipSpace();
                this.assertIgnoreCase("END");
                return new CaseStatement(caseCondition, whenThenList, elseClause);
            }
            return null;
        }

        private List<WhenThenClause> whenThenList() throws IOException, RDFParseException, RDFHandlerException {
            ArrayList<WhenThenClause> list = new ArrayList<WhenThenClause>();
            while (true) {
                this.skipSpace();
                if (this.tryCaseInsensitiveWord("WHEN") == null) break;
                this.skipSpace();
                Expression when = this.expression();
                this.skipSpace();
                this.assertIgnoreCase("THEN");
                Expression then = this.expression();
                list.add(new WhenThenClause(when, then));
            }
            if (list.isEmpty()) {
                throw new RDFParseException("CASE statement is missing WHEN...THEN clause");
            }
            return list;
        }

        private List<Expression> argList() throws IOException, RDFParseException, RDFHandlerException {
            ArrayList<Expression> result = new ArrayList<Expression>();
            int c = 0;
            do {
                BareExpression arg = this.expr();
                result.add(arg);
            } while ((c = this.next()) == 44);
            this.unread(c);
            return result;
        }

        private PathExpression tryPath() throws RDFParseException, IOException, RDFHandlerException {
            int next = this.next();
            if (next != 63 && next != 36) {
                this.unread(next);
                return null;
            }
            PathExpression path = new PathExpression();
            if (next == 63) {
                this.unread(next);
                VariableTerm var = this.variable();
                path.add(new DirectionStep(Direction.OUT, var));
            }
            next = this.peek();
            while (next == 94 || next == 46 || next == 91) {
                switch (next) {
                    case 46: {
                        path.add(this.outStep());
                        break;
                    }
                    case 94: {
                        path.add(this.inStep());
                        break;
                    }
                    case 91: {
                        path.add(this.hasStep());
                    }
                }
                this.skipSpace();
                next = this.peek();
            }
            return path;
        }

        private PathStep hasStep() throws RDFParseException, RDFHandlerException, IOException {
            List<PredicateObjectList> constraints = this.predicateObjectList();
            return new HasPathStep(constraints);
        }

        private PathStep inStep() throws RDFParseException, IOException {
            this.assertNext(94);
            return new DirectionStep(Direction.IN, this.pathTerm());
        }

        private PathStep outStep() throws RDFParseException, IOException {
            this.assertNext(46);
            return new DirectionStep(Direction.OUT, this.pathTerm());
        }

        private List<PredicateObjectList> predicateObjectList() throws IOException, RDFParseException, RDFHandlerException {
            ArrayList<PredicateObjectList> list;
            block4: {
                int next;
                block3: {
                    this.assertNext(91);
                    list = new ArrayList<PredicateObjectList>();
                    do {
                        PathExpression path;
                        if ((path = this.tryPath()) == null) {
                            IriValue predicate = this.iriValue();
                            path = new PathExpression();
                            path.add(new DirectionStep(Direction.OUT, (PathTerm)predicate));
                        }
                        ObjectList objectList = this.objectList();
                        list.add(new PredicateObjectList(path, objectList));
                        next = this.next();
                        if (next != 59) break block3;
                        this.skipSpace();
                    } while ((next = this.peek()) != 93);
                    break block4;
                }
                if (next != 93) {
                    throw new RDFParseException("Invalid predicateObjectList");
                }
            }
            return list;
        }

        private ObjectList objectList() throws RDFParseException, RDFHandlerException, IOException {
            int next;
            ArrayList<Expression> list = new ArrayList<Expression>();
            do {
                Expression e = this.expression();
                list.add(e);
            } while ((next = this.next()) == 44);
            this.unread(next);
            return new ObjectList(list);
        }

        private IriValue iriValue() throws RDFParseException, IOException {
            PathTerm result = null;
            PathTerm term = this.tryPathTerm();
            if (term instanceof IriValue) {
                result = term;
            } else {
                this.fail("Expected IRI value");
            }
            return result;
        }

        private PathTerm pathTerm() throws RDFParseException, IOException {
            PathTerm predicate = this.tryPathTerm();
            if (predicate == null) {
                this.fail("Expected a predicate");
            }
            return predicate;
        }

        private PathTerm tryPathTerm() throws RDFParseException, IOException {
            String predicate = null;
            this.skipSpace();
            int c = this.read();
            if (c == 60) {
                String value = this.iriRef(c);
                return new FullyQualifiedIri((URI)new URIImpl(value));
            }
            if (Character.isLetter(c)) {
                StringBuilder buffer = this.buffer();
                do {
                    buffer.appendCodePoint(c);
                } while (Character.isLetter(c = this.read()) || Character.isDigit(c) || c == 95);
                predicate = buffer.toString();
                if (c == 58) {
                    c = this.read();
                    if (Character.isLetter(c)) {
                        String namespace;
                        boolean ok;
                        buffer = this.buffer();
                        do {
                            buffer.appendCodePoint(c);
                        } while (Character.isLetter(c = this.read()) || Character.isDigit(c) || c == 95);
                        String prefix = predicate;
                        String localName = buffer.toString();
                        this.unread(c);
                        Context context = this.getContext();
                        boolean bl = ok = context.getTerm(prefix) != null;
                        if (!ok && this.namespaceMap != null && (namespace = this.namespaceMap.get(prefix)) != null) {
                            Term term = context.addTerm(prefix, namespace);
                            term.setKind(Term.Kind.NAMESPACE);
                            ok = true;
                        }
                        if (!ok) {
                            throw new RDFParseException("Namespace not defined for prefix: " + prefix);
                        }
                        return new CurieValue(this.getContext(), prefix, localName);
                    }
                    this.fail("Expected a letter");
                }
            }
            this.unread(c);
            if ("IN".equalsIgnoreCase(predicate)) {
                this.unread(predicate);
                predicate = null;
            } else if ("NOT".equalsIgnoreCase(predicate)) {
                this.unread(predicate);
                predicate = null;
            } else if ("THEN".equalsIgnoreCase(predicate)) {
                this.unread(predicate);
                predicate = null;
            } else if ("WHEN".equalsIgnoreCase(predicate)) {
                this.unread(predicate);
                predicate = null;
            } else if ("ELSE".equalsIgnoreCase(predicate)) {
                this.unread(predicate);
                predicate = null;
            } else if ("END".equalsIgnoreCase(predicate)) {
                this.unread(predicate);
                predicate = null;
            }
            if (predicate == null) {
                return null;
            }
            String localName = predicate;
            Context context = this.getContext();
            Term term = context.getTerm(localName);
            if (term == null && FormulaParser.this.localNameService != null) {
                Set<URI> iriOptions = FormulaParser.this.localNameService.lookupLocalName(localName);
                if (iriOptions.size() == 1) {
                    URI id = iriOptions.iterator().next();
                    term = new Term(localName, id.stringValue(), Term.Kind.ANY);
                    context.add(term);
                } else {
                    if (iriOptions.isEmpty()) {
                        String msg = MessageFormat.format("Local name not found: {0}", localName);
                        throw new RDFParseException(msg);
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append("Local name \"");
                    builder.append(localName);
                    builder.append("\" is ambiguous.  Could be one of");
                    for (URI iri : iriOptions) {
                        builder.append("\n   ");
                        builder.append(iri.stringValue());
                    }
                    throw new RDFParseException(builder.toString());
                }
            }
            return new LocalNameTerm(context, predicate);
        }

        private VariableTerm variable() throws RDFParseException, IOException {
            Set<URI> set;
            this.assertNext(63);
            this.buffer = this.buffer();
            int c = this.read();
            do {
                this.buffer.appendCodePoint(c);
            } while (Character.isLetter(c = this.read()) || Character.isDigit(c) || c == 95);
            this.unread(c);
            String varName = this.buffer.toString();
            Context context = this.getContext();
            String termName = varName;
            Term term = context.getTerm(termName);
            if (term != null) {
                String iri = context.expandIRI(termName);
                return new VariableTerm(varName, (URI)new URIImpl(iri));
            }
            if (FormulaParser.this.localNameService != null && (set = FormulaParser.this.localNameService.lookupLocalName(termName)).size() == 1) {
                URI varId = set.iterator().next();
                context.addTerm(termName, varId.stringValue());
                return new VariableTerm(varName, varId);
            }
            VariableTerm result = new VariableTerm(varName);
            context.addTerm(varName, result.getIri().stringValue());
            return result;
        }

        private LiteralFormula tryLiteralFormula() throws RDFParseException, RDFHandlerException, IOException {
            Literal literal = this.tryLiteral();
            return literal == null ? null : new LiteralFormula(literal);
        }

        private BrackettedExpression tryBrackettedExpression() throws IOException, RDFParseException, RDFHandlerException {
            BrackettedExpression bracket = null;
            this.skipSpace();
            int c = this.read();
            if (c == 40) {
                this.skipSpace();
                Expression e = this.expression();
                this.skipSpace();
                this.assertNext(41);
                bracket = new BrackettedExpression(e);
            } else {
                this.unread(c);
            }
            return bracket;
        }

        private ConditionalAndExpression conditionalAndExpression() throws RDFParseException, IOException, RDFHandlerException {
            ConditionalAndExpression and = this.tryConditionalAndExpression();
            if (and == null) {
                this.fail("Expected ConditionalAndExpression");
            }
            return and;
        }
    }
}

