/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import io.konig.formula.AbstractFormula;
import io.konig.formula.BuiltInCall;
import io.konig.formula.ConditionalOrExpression;
import io.konig.formula.Expression;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.FullyQualifiedIri;
import io.konig.formula.FunctionModel;
import io.konig.formula.LiteralFormula;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

public class FunctionExpression
extends AbstractFormula
implements BuiltInCall {
    public static final String SUM = "SUM";
    public static final String AVG = "AVG";
    public static final String COUNT = "COUNT";
    public static final String DAY = "DAY";
    public static final String MONTH = "MONTH";
    public static final String YEAR = "YEAR";
    public static final String TIME_INTERVAL = "TIME_INTERVAL";
    public static final String UNIX_TIME = "UNIX_TIME";
    public static final String CONCAT = "CONCAT";
    public static final String SUBSTR = "SUBSTR";
    public static final String STRPOS = "STRPOS";
    public static final String IRI = "IRI";
    public static final String STRIP_SPACES = "STRIP_SPACES";
    private String functionName;
    private List<Expression> argList = new ArrayList<Expression>();
    private FunctionModel model;

    public static FunctionExpression fromIriTemplate(IriTemplate template) {
        ArrayList<Expression> argList = new ArrayList<Expression>();
        Context context = template.getContext();
        context.compile();
        for (ValueFormat.Element element : template.toList()) {
            String text = element.getText();
            switch (element.getType()) {
                case TEXT: {
                    LiteralImpl literal = new LiteralImpl(text);
                    argList.add(ConditionalOrExpression.wrap(new LiteralFormula((Literal)literal)));
                    break;
                }
                case VARIABLE: {
                    URIImpl iri = new URIImpl(context.expandIRI(text));
                    FullyQualifiedIri iriTerm = new FullyQualifiedIri((URI)iri);
                    argList.add(ConditionalOrExpression.wrap(iriTerm));
                }
            }
        }
        return new FunctionExpression(FunctionModel.CONCAT, argList);
    }

    public FunctionExpression(FunctionModel model, Expression ... arg) {
        this.functionName = model.getName();
        this.model = model;
        this.argList = new ArrayList<Expression>();
        for (Expression e : arg) {
            this.argList.add(e);
        }
    }

    public FunctionExpression(FunctionModel model, List<Expression> argList) {
        this.functionName = model.getName();
        this.model = model;
        this.argList = argList;
    }

    public FunctionModel getModel() {
        return this.model;
    }

    public boolean isAggregation() {
        return this.functionName.equalsIgnoreCase(SUM) || this.functionName.equalsIgnoreCase(COUNT);
    }

    public static String getSum() {
        return SUM;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void addArg(Expression arg) {
        this.argList.add(arg);
    }

    public List<Expression> getArgList() {
        return this.argList;
    }

    @Override
    public FunctionExpression clone() {
        ArrayList<Expression> otherArgList = new ArrayList<Expression>();
        for (Expression e : this.argList) {
            otherArgList.add(e.clone());
        }
        return new FunctionExpression(this.model, otherArgList);
    }

    @Override
    public void print(PrettyPrintWriter out) {
        out.print(this.functionName);
        out.print('(');
        String comma = "";
        for (Expression arg : this.argList) {
            out.print(comma);
            comma = ", ";
            out.print(arg);
        }
        out.print(')');
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        for (Expression arg : this.argList) {
            arg.dispatch(visitor);
        }
        visitor.exit(this);
    }
}

