/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.KonigException;
import io.konig.formula.DateTruncFunctionModel;
import io.konig.formula.KqlType;
import io.konig.formula.ParameterModel;
import java.util.ArrayList;
import java.util.List;

public class FunctionModel {
    public static final FunctionModel CONCAT = new FunctionModel("CONCAT", KqlType.STRING).param("stringValue", KqlType.STRING, true);
    public static final FunctionModel SUM = new FunctionModel("SUM", KqlType.NUMBER).param("expr", KqlType.NUMBER);
    public static final FunctionModel AVG = new FunctionModel("AVG", KqlType.NUMBER).param("expr", KqlType.NUMBER);
    public static final FunctionModel COUNT = new FunctionModel("COUNT", KqlType.NUMBER).param("expr", KqlType.NUMBER);
    public static final FunctionModel UNIX_TIME = new FunctionModel("UNIX_TIME", KqlType.INTEGER).param("temporalValue", KqlType.INSTANT);
    public static final FunctionModel DAY = new DateTruncFunctionModel("DAY", KqlType.INSTANT).param("timestamp", KqlType.INSTANT);
    public static final FunctionModel MONTH = new DateTruncFunctionModel("MONTH", KqlType.INSTANT).param("timestamp", KqlType.INSTANT);
    public static final FunctionModel YEAR = new DateTruncFunctionModel("YEAR", KqlType.INSTANT).param("timestamp", KqlType.INSTANT);
    public static final FunctionModel STRPOS = new FunctionModel("STRPOS", KqlType.INTEGER).param("sourceString", KqlType.STRING).param("subString", KqlType.STRING);
    public static final FunctionModel IRI = new FunctionModel("IRI", KqlType.IRI).param("stringValue", KqlType.STRING);
    public static final FunctionModel STRIP_SPACES = new FunctionModel("STRIP_SPACES", KqlType.STRING).param("stringValue", KqlType.STRING);
    public static final FunctionModel SUBSTR = new FunctionModel("SUBSTR", KqlType.STRING).param("sourceString", KqlType.STRING).param("start", KqlType.INTEGER).param("length", KqlType.INTEGER);
    private static FunctionModel[] LIST = new FunctionModel[]{AVG, CONCAT, COUNT, DAY, MONTH, STRPOS, SUBSTR, SUM, UNIX_TIME, YEAR};
    private String name;
    private KqlType returnType;
    private List<ParameterModel> parameters = new ArrayList<ParameterModel>();

    public static FunctionModel fromName(String name) {
        for (FunctionModel m : LIST) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        throw new KonigException("Unknown function: " + name);
    }

    public FunctionModel(String name, KqlType returnType) {
        this.name = name;
        this.returnType = returnType;
    }

    public FunctionModel param(String name, KqlType type) {
        this.parameters.add(new ParameterModel(name, type));
        return this;
    }

    public FunctionModel param(String name, KqlType type, boolean ellipsis) {
        this.parameters.add(new ParameterModel(name, type, ellipsis));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<ParameterModel> getParameters() {
        return this.parameters;
    }

    public KqlType getReturnType() {
        return this.returnType;
    }
}

