/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.Addend;
import io.konig.formula.AdditiveExpression;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.MultiplicativeExpression;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.UnaryExpression;
import java.util.ArrayList;
import java.util.List;

public class GeneralAdditiveExpression
extends AbstractFormula
implements AdditiveExpression {
    private MultiplicativeExpression left;
    private List<Addend> addendList = new ArrayList<Addend>();

    public GeneralAdditiveExpression(MultiplicativeExpression left) {
        this.left = left;
    }

    public static GeneralAdditiveExpression wrap(PrimaryExpression primary) {
        UnaryExpression unary = new UnaryExpression(primary);
        MultiplicativeExpression mult = new MultiplicativeExpression(unary);
        return new GeneralAdditiveExpression(mult);
    }

    @Override
    public PrimaryExpression asPrimaryExpression() {
        if (this.addendList == null || this.addendList.isEmpty()) {
            return this.left.asPrimaryExpression();
        }
        return null;
    }

    @Override
    public GeneralAdditiveExpression clone() {
        GeneralAdditiveExpression other = new GeneralAdditiveExpression(this.left.clone());
        for (Addend a : this.addendList) {
            other.add(a.clone());
        }
        return other;
    }

    public MultiplicativeExpression getLeft() {
        return this.left;
    }

    public void add(Addend addend) {
        this.addendList.add(addend);
    }

    public List<Addend> getAddendList() {
        return this.addendList;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        this.left.print(out);
        for (Addend addend : this.addendList) {
            addend.print(out);
        }
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        this.left.dispatch(visitor);
        for (Addend a : this.addendList) {
            a.dispatch(visitor);
        }
        visitor.exit(this);
    }
}

