/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.Term;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.PathTerm;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class LocalNameTerm
extends AbstractFormula
implements PathTerm {
    private String localName;
    private Context context;

    public LocalNameTerm(Context context, String localName) {
        this.context = context;
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public LocalNameTerm clone() {
        return new LocalNameTerm(this.context, this.localName);
    }

    @Override
    public void print(PrettyPrintWriter out) {
        out.print(this.localName);
    }

    @Override
    public URI getIri() {
        Term term = this.context.getTerm(this.localName);
        if (term == null) {
            throw new KonigException("Cannot resolve localName: " + this.localName);
        }
        return new URIImpl(term.getExpandedIdValue());
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }
}

