/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.Factor;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.UnaryExpression;
import java.util.ArrayList;
import java.util.List;

public class MultiplicativeExpression
extends AbstractFormula {
    private UnaryExpression left;
    private List<Factor> multiplierList = new ArrayList<Factor>();

    public MultiplicativeExpression(UnaryExpression left) {
        this.left = left;
    }

    public UnaryExpression getLeft() {
        return this.left;
    }

    @Override
    public PrimaryExpression asPrimaryExpression() {
        if (this.multiplierList == null || this.multiplierList.isEmpty()) {
            return this.left.getPrimary();
        }
        return null;
    }

    @Override
    public MultiplicativeExpression clone() {
        MultiplicativeExpression other = new MultiplicativeExpression(this.left.clone());
        for (Factor factor : this.multiplierList) {
            other.add(factor.clone());
        }
        return other;
    }

    public List<Factor> getMultiplierList() {
        return this.multiplierList;
    }

    public void add(Factor multiplier) {
        this.multiplierList.add(multiplier);
    }

    @Override
    public void print(PrettyPrintWriter out) {
        this.left.print(out);
        for (Factor m : this.multiplierList) {
            m.print(out);
        }
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        this.left.dispatch(visitor);
        for (Factor f : this.multiplierList) {
            f.dispatch(visitor);
        }
        visitor.exit(this);
    }
}

