/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.Path;
import io.konig.core.Term;
import io.konig.core.path.HasStep;
import io.konig.core.path.InStep;
import io.konig.core.path.OutStep;
import io.konig.core.path.Step;
import io.konig.core.path.VertexStep;
import io.konig.formula.BasicExpression;
import io.konig.formula.BinaryRelationalExpression;
import io.konig.formula.ConditionalAndExpression;
import io.konig.formula.CurieValue;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.Expression;
import io.konig.formula.FullyQualifiedIri;
import io.konig.formula.GeneralAdditiveExpression;
import io.konig.formula.HasPathStep;
import io.konig.formula.LiteralFormula;
import io.konig.formula.LocalNameTerm;
import io.konig.formula.MultiplicativeExpression;
import io.konig.formula.ObjectList;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import io.konig.formula.PredicateObjectList;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.UnaryExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class Path2FormulaTranslator {
    private static final Path2FormulaTranslator INSTANCE = new Path2FormulaTranslator();

    public static Path2FormulaTranslator getInstance() {
        return INSTANCE;
    }

    public QuantifiedExpression toQuantifiedExpression(Path path) {
        PathExpression pathExpr = this.toPathExpression(path);
        UnaryExpression unary = new UnaryExpression(null, pathExpr);
        MultiplicativeExpression mult = new MultiplicativeExpression(unary);
        GeneralAdditiveExpression add = new GeneralAdditiveExpression(mult);
        BinaryRelationalExpression binary = new BinaryRelationalExpression(null, add, null);
        ConditionalAndExpression and = new ConditionalAndExpression();
        and.add(binary);
        QuantifiedExpression quantified = new QuantifiedExpression();
        quantified.setContext(path.getContext());
        quantified.add(and);
        return quantified;
    }

    private PathExpression toPathExpression(Path path) {
        List<Step> stepList = path.asList();
        Context context = path.getContext();
        PathExpression e = new PathExpression();
        for (Step step : stepList) {
            e.add(this.toPathStep(step, context));
        }
        return e;
    }

    private PathStep toPathStep(Step step, Context context) {
        PathStep result = null;
        if (step instanceof OutStep) {
            result = this.directionStep(Direction.OUT, ((OutStep)step).getPredicate(), context);
        } else if (step instanceof InStep) {
            result = this.directionStep(Direction.IN, ((InStep)step).getPredicate(), context);
        } else if (step instanceof HasStep) {
            result = this.hasStep((HasStep)step, context);
        } else if (step instanceof VertexStep) {
            throw new KonigException("VertexStep is not supported");
        }
        return result;
    }

    private HasPathStep hasStep(HasStep step, Context context) {
        HashMap<URI, PredicateObjectList> map = new HashMap<URI, PredicateObjectList>();
        ArrayList<PredicateObjectList> constraints = new ArrayList<PredicateObjectList>();
        for (HasStep.PredicateValuePair pair : step.getPairList()) {
            URI predicate = pair.getPredicate();
            Value value = pair.getValue();
            Expression valueExpression = this.toExpression(value, context);
            PredicateObjectList pol = (PredicateObjectList)map.get(predicate);
            if (pol == null) {
                PathTerm predicateValue = this.iriValue(predicate, context);
                ArrayList<Expression> expressionList = new ArrayList<Expression>();
                ObjectList objectList = new ObjectList(expressionList);
                expressionList.add(valueExpression);
                PathExpression path = new PathExpression();
                path.add(new DirectionStep(Direction.OUT, predicateValue));
                pol = new PredicateObjectList(path, objectList);
                constraints.add(pol);
                map.put(predicate, pol);
                continue;
            }
            pol.getObjectList().getExpressions().add(valueExpression);
        }
        HasPathStep result = new HasPathStep(constraints);
        return result;
    }

    private Expression toExpression(Value value, Context context) {
        PrimaryExpression primary = this.toPrimaryExpression(value, context);
        UnaryExpression unary = new UnaryExpression(null, primary);
        MultiplicativeExpression mult = new MultiplicativeExpression(unary);
        GeneralAdditiveExpression add = new GeneralAdditiveExpression(mult);
        BinaryRelationalExpression binary = new BinaryRelationalExpression(null, add, null);
        ConditionalAndExpression and = new ConditionalAndExpression();
        and.add(binary);
        BasicExpression result = new BasicExpression();
        result.setContext(context);
        result.add(and);
        return result;
    }

    private PrimaryExpression toPrimaryExpression(Value value, Context context) {
        if (value instanceof URI) {
            return this.iriValue((URI)value, context);
        }
        if (value instanceof Literal) {
            return new LiteralFormula((Literal)value);
        }
        throw new KonigException("PrimaryExpression for BNode not supported");
    }

    private PathTerm iriValue(URI predicate, Context context) {
        if (context == null) {
            return new FullyQualifiedIri(predicate);
        }
        String predicateValue = predicate.stringValue();
        String localName = predicate.getLocalName();
        Term term = context.getTerm(localName);
        if (term != null && predicateValue.equals(term.getId())) {
            return new LocalNameTerm(context, localName);
        }
        String namespace = predicate.getNamespace();
        Context inverse = context.inverse();
        term = inverse.getTerm(namespace);
        if (term != null) {
            return new CurieValue(context, term.getKey(), localName);
        }
        return new FullyQualifiedIri(predicate);
    }

    private PathStep directionStep(Direction direction, URI predicate, Context context) {
        PathTerm pathTerm = this.iriValue(predicate, context);
        return new DirectionStep(direction, pathTerm);
    }
}

