/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.FullyQualifiedIri;
import io.konig.formula.PathStep;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.VariableTerm;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openrdf.model.URI;

public class PathExpression
extends AbstractFormula
implements PrimaryExpression {
    private List<PathStep> stepList = new ArrayList<PathStep>();

    public static PathExpressionBuilder builder() {
        return new PathExpressionBuilder();
    }

    @Override
    public PathExpression clone() {
        PathExpression other = new PathExpression();
        for (PathStep step : this.stepList) {
            other.add(step.clone());
        }
        return other;
    }

    public void add(PathStep step) {
        this.stepList.add(step);
    }

    public List<PathStep> getStepList() {
        return this.stepList;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        if (!this.stepList.isEmpty()) {
            Iterator<PathStep> sequence = this.stepList.iterator();
            if (!this.stepList.isEmpty()) {
                DirectionStep dirStep;
                String dollar = "$";
                PathStep first = this.stepList.get(0);
                if (first instanceof DirectionStep && (dirStep = (DirectionStep)first).getTerm() instanceof VariableTerm) {
                    dollar = "";
                }
                out.print(dollar);
            }
            while (sequence.hasNext()) {
                PathStep step = sequence.next();
                step.print(out);
            }
        } else {
            out.print('$');
        }
    }

    public String simpleText() {
        StringWriter writer = new StringWriter();
        PrettyPrintWriter pretty = new PrettyPrintWriter(writer);
        pretty.setSuppressContext(true);
        this.print(pretty);
        pretty.close();
        return writer.toString();
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        for (PathStep s : this.stepList) {
            s.dispatch(visitor);
        }
        visitor.exit(this);
    }

    public static PathExpression toPathExpression(QuantifiedExpression formula) {
        if (formula == null) {
            return null;
        }
        PrimaryExpression primary = formula.asPrimaryExpression();
        return primary instanceof PathExpression ? (PathExpression)primary : null;
    }

    public DirectionStep directionStepAfter(int i) {
        for (int j = i + 1; j < this.stepList.size(); ++j) {
            PathStep step = this.stepList.get(j);
            if (!(step instanceof DirectionStep)) continue;
            return (DirectionStep)step;
        }
        return null;
    }

    public DirectionStep directionStepBefore(int i) {
        for (int j = i - 1; j >= 0; --j) {
            PathStep step = this.stepList.get(j);
            if (!(step instanceof DirectionStep)) continue;
            return (DirectionStep)step;
        }
        return null;
    }

    public static class PathExpressionBuilder {
        private PathExpression path = new PathExpression();

        private PathExpressionBuilder() {
        }

        public PathExpressionBuilder out(URI predicate) {
            DirectionStep step = new DirectionStep(Direction.OUT, new FullyQualifiedIri(predicate));
            this.path.add(step);
            return this;
        }

        public PathExpression build() {
            return this.path;
        }
    }
}

