/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.IriValue;
import io.konig.formula.ObjectList;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import java.util.List;

public class PredicateObjectList
extends AbstractFormula {
    private PathExpression path;
    private ObjectList objectList;

    public PredicateObjectList(PathExpression path, ObjectList objectList) {
        this.path = path;
        this.objectList = objectList;
    }

    public IriValue getVerb() {
        DirectionStep dirStep;
        PathStep step;
        List<PathStep> list = this.path.getStepList();
        if (list.size() == 1 && (step = list.get(0)) instanceof DirectionStep && (dirStep = (DirectionStep)step).getDirection() == Direction.OUT) {
            return dirStep.getTerm();
        }
        return null;
    }

    @Override
    public PredicateObjectList clone() {
        return new PredicateObjectList(this.path.clone(), this.objectList.clone());
    }

    public PathExpression getPath() {
        return this.path;
    }

    public ObjectList getObjectList() {
        return this.objectList;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        PathTerm predicate = this.predicatePath();
        if (predicate != null) {
            predicate.print(out);
        } else {
            this.path.print(out);
        }
        out.print(' ');
        this.objectList.print(out);
    }

    private PathTerm predicatePath() {
        DirectionStep dirStep;
        PathStep step;
        if (this.path.getStepList().size() == 1 && (step = this.path.getStepList().get(0)) instanceof DirectionStep && (dirStep = (DirectionStep)step).getDirection() == Direction.OUT) {
            return dirStep.getTerm();
        }
        return null;
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        this.path.dispatch(visitor);
        this.objectList.dispatch(visitor);
        visitor.exit(this);
    }
}

