/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.BinaryRelationalExpression;
import io.konig.formula.ConditionalAndExpression;
import io.konig.formula.ConditionalOrExpression;
import io.konig.formula.Expression;
import io.konig.formula.FormulaParser;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.GeneralAdditiveExpression;
import io.konig.formula.MultiplicativeExpression;
import io.konig.formula.NumericExpression;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.Triple;
import io.konig.formula.UnaryExpression;
import io.konig.formula.ValueLogical;
import java.util.ArrayList;
import java.util.List;

public class QuantifiedExpression
extends Expression {
    private List<Triple> statementList;

    public static final QuantifiedExpression fromString(String text) {
        try {
            FormulaParser parser = new FormulaParser();
            return parser.quantifiedExpression(text);
        }
        catch (Throwable oops) {
            throw new KonigException("Failed to parse expression: " + text, oops);
        }
    }

    public QuantifiedExpression() {
    }

    protected QuantifiedExpression(Context context, List<ConditionalAndExpression> orList, List<Triple> statementList) {
        super(context, orList);
        this.statementList = statementList;
    }

    @Override
    public QuantifiedExpression clone() {
        return new QuantifiedExpression(this.context, this.clone(this.orList), this.cloneStatementList());
    }

    private List<Triple> cloneStatementList() {
        if (this.statementList == null) {
            return null;
        }
        ArrayList<Triple> list = new ArrayList<Triple>();
        for (Triple e : this.statementList) {
            list.add(e.clone());
        }
        return list;
    }

    private List<ConditionalAndExpression> clone(List<ConditionalAndExpression> orList) {
        if (orList == null) {
            return null;
        }
        ArrayList<ConditionalAndExpression> result = new ArrayList<ConditionalAndExpression>();
        for (ConditionalAndExpression e : orList) {
            result.add(e.clone());
        }
        return result;
    }

    @Override
    public String toSimpleString() {
        String[] text = this.toString().split("\\n");
        return text[text.length - 1];
    }

    public static QuantifiedExpression wrap(ValueLogical valueLogical) {
        ConditionalAndExpression and = new ConditionalAndExpression();
        and.add(valueLogical);
        ConditionalOrExpression or = new ConditionalOrExpression();
        or.add(and);
        return new QuantifiedExpression(or, null);
    }

    public static QuantifiedExpression wrap(NumericExpression numeric) {
        BinaryRelationalExpression valueLogical = new BinaryRelationalExpression(null, numeric, null);
        ConditionalAndExpression and = new ConditionalAndExpression();
        and.add(valueLogical);
        ConditionalOrExpression or = new ConditionalOrExpression();
        or.add(and);
        return new QuantifiedExpression(or, null);
    }

    public static QuantifiedExpression wrap(PrimaryExpression primary) {
        UnaryExpression unary = new UnaryExpression(primary);
        MultiplicativeExpression mult = new MultiplicativeExpression(unary);
        GeneralAdditiveExpression numeric = new GeneralAdditiveExpression(mult);
        BinaryRelationalExpression valueLogical = new BinaryRelationalExpression(null, numeric, null);
        ConditionalAndExpression and = new ConditionalAndExpression();
        and.add(valueLogical);
        ConditionalOrExpression or = new ConditionalOrExpression();
        or.add(and);
        return new QuantifiedExpression(or, null);
    }

    public QuantifiedExpression(Expression formula, List<Triple> statementList) {
        super(formula);
        this.statementList = statementList;
    }

    public QuantifiedExpression(String text) {
        this(QuantifiedExpression.fromString(text));
    }

    public QuantifiedExpression(QuantifiedExpression clone) {
        super(clone);
        this.statementList = clone.statementList;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        super.print(out);
        if (this.statementList != null && !this.statementList.isEmpty()) {
            out.println();
            out.indent();
            out.println("WHERE");
            out.pushIndent();
            for (Triple s : this.statementList) {
                out.indent();
                out.println(s);
            }
            out.popIndent();
        }
    }

    @Override
    protected void doDispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        if (this.statementList != null) {
            for (Triple s : this.statementList) {
                s.dispatch(visitor);
            }
        }
        visitor.exit(this);
    }
}

