/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.IriValue;
import io.konig.formula.PathTerm;

public class Triple
extends AbstractFormula {
    private PathTerm subject;
    private IriValue predicate;
    private PathTerm object;

    public Triple(PathTerm subject, IriValue predicate, PathTerm object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public PathTerm getSubject() {
        return this.subject;
    }

    public IriValue getPredicate() {
        return this.predicate;
    }

    public PathTerm getObject() {
        return this.object;
    }

    @Override
    public Triple clone() {
        return new Triple(this.subject.clone(), this.predicate.clone(), this.object.clone());
    }

    @Override
    public void print(PrettyPrintWriter out) {
        out.print(this.subject);
        out.print(' ');
        out.print(this.predicate);
        out.print(' ');
        out.print(this.object);
        out.print(" .");
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        this.subject.dispatch(visitor);
        this.predicate.dispatch(visitor);
        this.object.dispatch(visitor);
        visitor.exit(this);
    }
}

