/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula;

import io.konig.core.io.PrettyPrintWriter;
import io.konig.formula.AbstractFormula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.PathTerm;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class VariableTerm
extends AbstractFormula
implements PathTerm {
    private String varName;
    private URI varId;

    public VariableTerm(String varName) {
        this.varName = varName;
        this.varId = new URIImpl("http://www.konig.io/ns/var/" + varName);
    }

    public VariableTerm(String varName, URI varId) {
        this.varName = varName;
        this.varId = varId;
    }

    @Override
    public void print(PrettyPrintWriter out) {
        out.print('?');
        out.print(this.varName);
    }

    public String getVarName() {
        return this.varName;
    }

    @Override
    public void dispatch(FormulaVisitor visitor) {
        visitor.enter(this);
        visitor.exit(this);
    }

    @Override
    public URI getIri() {
        return this.varId;
    }

    @Override
    public VariableTerm clone() {
        return this;
    }
}

