/*
 * Decompiled with CFR 0.152.
 */
package io.konig.formula.builder;

import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.formula.ConditionalOrExpression;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.LocalNameTerm;
import io.konig.formula.PathExpression;
import io.konig.formula.builder.ExpressionConsumer;
import org.openrdf.model.URI;

public class PathBuilder<T extends ExpressionConsumer> {
    private T parent;
    private PathExpression path;
    private ConditionalOrExpression wrapper;

    public PathBuilder(T parent) {
        this.parent = parent;
        this.path = new PathExpression();
        this.wrapper = ConditionalOrExpression.wrap(this.path);
        this.wrapper.setContext(new BasicContext(null));
    }

    public PathBuilder<T> out(URI predicate) {
        this.wrapper.getContext().add(new Term(predicate.getLocalName(), predicate.stringValue()));
        this.path.add(new DirectionStep(Direction.OUT, new LocalNameTerm(this.wrapper.getContext(), predicate.getLocalName())));
        return this;
    }

    public PathBuilder<T> in(URI predicate) {
        this.wrapper.getContext().add(new Term(predicate.getLocalName(), predicate.stringValue()));
        this.path.add(new DirectionStep(Direction.IN, new LocalNameTerm(this.wrapper.getContext(), predicate.getLocalName())));
        return this;
    }

    public T endPath() {
        this.parent.setExpression(ConditionalOrExpression.wrap(this.path));
        return this.parent;
    }
}

