/*
 * Decompiled with CFR 0.152.
 */
package io.konig.lineage;

import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.io.Emitter;
import io.konig.lineage.LineageWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.openrdf.rio.RDFHandlerException;

public class LineageEmitter
implements Emitter {
    private File outFile;

    public LineageEmitter(File outFile) {
        this.outFile = outFile;
    }

    @Override
    public void emit(Graph graph) throws IOException, KonigException {
        this.outFile.getParentFile().mkdirs();
        try (FileWriter out = new FileWriter(this.outFile);){
            LineageWriter writer = new LineageWriter();
            writer.writeDatasourceProperties(out, graph.getNamespaceManager());
        }
        catch (RDFHandlerException e) {
            throw new KonigException("Failed to write file: " + this.outFile.getName(), e);
        }
    }
}

