/*
 * Decompiled with CFR 0.152.
 */
package io.konig.lineage;

import io.konig.core.Graph;
import io.konig.core.pojo.PojoContext;
import io.konig.core.pojo.PojoListener;
import io.konig.core.pojo.SimplePojoFactory;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.lineage.DatasourceProperty;
import io.konig.lineage.PropertyGenerator;
import io.konig.shacl.io.MasterDataSourcePojoHandler;
import org.openrdf.model.Resource;

public class LineageLoader {
    public static final PojoContext CONTEXT = new PojoContext();

    public void load(Graph graph) {
        PojoContext context = new PojoContext(CONTEXT);
        context.putPojoHandler(DataSource.class, new MasterDataSourcePojoHandler());
        context.setListener(new PojoListener(){

            @Override
            public void map(Resource id, Object pojo) {
                DatasourceProperty p;
                if (pojo instanceof DatasourceProperty && (p = (DatasourceProperty)pojo).getPropertySource() != null) {
                    p.getPropertySource().addDatasourceProperty(p);
                }
            }
        });
        SimplePojoFactory factory = new SimplePojoFactory(context);
        factory.createAll(graph);
    }

    static {
        CONTEXT.mapClass((Resource)Konig.DatasourceProperty, DatasourceProperty.class);
        CONTEXT.mapClass((Resource)Konig.PropertyGenerator, PropertyGenerator.class);
    }
}

