/*
 * Decompiled with CFR 0.152.
 */
package io.konig.lineage;

import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryGraph;
import io.konig.core.impl.RdfUtil;
import io.konig.core.pojo.EmitContext;
import io.konig.core.pojo.SimplePojoEmitter;
import io.konig.datasource.DataSource;
import io.konig.datasource.DataSourceManager;
import io.konig.lineage.DatasourceProperty;
import java.io.IOException;
import java.io.Writer;
import org.openrdf.rio.RDFHandlerException;

public class LineageWriter {
    public void writeDatasourceProperties(Writer out, NamespaceManager nsManager) throws IOException, RDFHandlerException {
        MemoryGraph graph = new MemoryGraph(nsManager);
        EmitContext context = new EmitContext(graph);
        context.setIriReferenceByDefault(true);
        SimplePojoEmitter emitter = SimplePojoEmitter.getInstance();
        for (DataSource ds : DataSourceManager.getInstance().listDataSources()) {
            for (DatasourceProperty p : ds.getDatasourceProperty()) {
                emitter.emit(context, p, graph);
                if (p.getGeneratedFrom() == null) continue;
                emitter.emit(context, p.getGeneratedFrom(), graph);
            }
        }
        RdfUtil.prettyPrintTurtle((Graph)graph, out);
        out.flush();
    }
}

