/*
 * Decompiled with CFR 0.152.
 */
package io.konig.lineage;

import io.konig.annotation.RdfProperty;
import io.konig.core.vocab.Konig;
import io.konig.lineage.DatasourceProperty;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.model.URI;

public class PropertyGenerator {
    private URI id;
    private DatasourceProperty generatorOutput;
    private Set<DatasourceProperty> generatorInput;

    @RdfProperty(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    public URI getType() {
        return Konig.PropertyGenerator;
    }

    public URI getId() {
        return this.id;
    }

    public void setId(URI id) {
        this.id = id;
    }

    @RdfProperty(value="http://www.konig.io/ns/core/generatorOutput")
    public DatasourceProperty getGeneratorOutput() {
        return this.generatorOutput;
    }

    public void setGeneratorOutput(DatasourceProperty generatorOutput) {
        this.generatorOutput = generatorOutput;
    }

    public void addGeneratorInput(DatasourceProperty p) {
        if (this.generatorInput == null) {
            this.generatorInput = new LinkedHashSet<DatasourceProperty>();
        }
        this.generatorInput.add(p);
    }

    @RdfProperty(value="http://www.konig.io/ns/core/generatorInput")
    public Set<DatasourceProperty> getGeneratorInput() {
        return this.generatorInput == null ? Collections.emptySet() : this.generatorInput;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PropertyGenerator(\n");
        builder.append("  id: ");
        builder.append(this.id);
        if (this.generatorOutput != null) {
            builder.append("  output: ");
            builder.append(this.generatorOutput.getPropertyPath().simpleName());
            builder.append("\n");
        }
        if (this.generatorInput != null) {
            builder.append("  input: ");
            if (this.generatorInput.size() == 1) {
                builder.append(this.generatorInput.iterator().next().getPropertyPath().simpleName());
            } else {
                String comma = "\n      ";
                for (DatasourceProperty p : this.generatorInput) {
                    builder.append(comma);
                    builder.append(p.getPropertyPath().simpleName());
                    comma = ",\n      ";
                }
            }
        }
        builder.append("\n)");
        return builder.toString();
    }
}

