/*
 * Decompiled with CFR 0.152.
 */
package io.konig.model;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.vocab.SH;
import io.konig.model.MergeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelMerger {
    private static final Logger logger = LoggerFactory.getLogger(ModelMerger.class);

    public void merge(Graph source, Graph sink) throws MergeException {
        for (Vertex v : source.vertices()) {
            this.mergeVertex(v, sink);
        }
    }

    private void mergeVertices(Vertex v, Vertex w, Graph sink) throws MergeException {
        if (w == null) {
            this.copy(v, sink);
        } else {
            Set<Map.Entry<URI, Set<Edge>>> out = v.outEdges();
            for (Map.Entry<URI, Set<Edge>> entry : out) {
                URI predicate = entry.getKey();
                Set<Edge> sourceValues = entry.getValue();
                Set<Edge> sinkValues = w.outProperty(predicate);
                if (sinkValues.isEmpty()) {
                    this.copyEdges(sourceValues, sink);
                    continue;
                }
                boolean distinct = sourceValues.size() == 1 && sinkValues.size() == 1;
                Map<String, Vertex> bnodeMap = this.bnodeMap(w, predicate, sinkValues);
                for (Edge sourceEdge : sourceValues) {
                    Vertex aNode;
                    String aKey;
                    Value a = sourceEdge.getObject();
                    if (a instanceof URI) {
                        if (distinct) {
                            Value b = sourceValues.iterator().next().getObject();
                            if (a.equals(b)) continue;
                            StringBuilder msg = new StringBuilder();
                            msg.append("Entity <");
                            msg.append(v.getId().stringValue());
                            msg.append("> has incompatible values for '");
                            msg.append(predicate.getLocalName());
                            msg.append("': <");
                            msg.append(a.stringValue());
                            msg.append("> and <");
                            msg.append(b.stringValue());
                            msg.append(">");
                            throw new MergeException(msg.toString());
                        }
                        if (this.containsValue(a, sinkValues)) continue;
                        sink.edge(w.getId(), predicate, a);
                        continue;
                    }
                    if (a instanceof Literal) {
                        if (distinct || this.containsValue(a, sinkValues)) continue;
                        sink.edge(w.getId(), predicate, a);
                        continue;
                    }
                    if (!(a instanceof BNode) || (aKey = this.bnodeKey(v, predicate, aNode = v.getGraph().getVertex((Resource)((BNode)a)))) == null) continue;
                    Vertex bNode = bnodeMap.get(aKey);
                    this.mergeVertices(aNode, bNode, sink);
                }
            }
        }
    }

    private void mergeVertex(Vertex v, Graph sink) throws MergeException {
        Vertex w = sink.getVertex(v.getId());
        this.mergeVertices(v, w, sink);
    }

    private Map<String, Vertex> bnodeMap(Vertex w, URI predicate, Set<Edge> outEdges) {
        HashMap<String, Vertex> map = new HashMap<String, Vertex>();
        for (Edge edge : outEdges) {
            Value object = edge.getObject();
            if (!(object instanceof BNode)) continue;
            Vertex bnode = w.getGraph().getVertex((Resource)((BNode)object));
            String key = this.bnodeKey(w, predicate, bnode);
            if (key != null) {
                map.put(key, bnode);
                continue;
            }
            logger.warn("Failed to create BNode key for predicate: " + predicate.getLocalName());
        }
        return map;
    }

    private String bnodeKey(Vertex w, URI predicate, Vertex bnode) {
        StringBuilder builder = new StringBuilder();
        if (predicate.equals((Object)RDFS.SUBCLASSOF)) {
            this.appendKey(builder, bnode, OWL.ONPROPERTY);
            this.appendKeyTerm(builder, bnode, OWL.ALLVALUESFROM);
            this.appendKeyTerm(builder, bnode, OWL.SOMEVALUESFROM);
            this.appendKeyTerm(builder, bnode, OWL.HASVALUE);
            this.appendKeyTerm(builder, bnode, OWL.MAXCARDINALITY);
            this.appendKeyTerm(builder, bnode, OWL.MINCARDINALITY);
            this.appendKeyTerm(builder, bnode, OWL.CARDINALITY);
        } else if (predicate.equals((Object)SH.property)) {
            this.appendKey(builder, bnode, SH.path);
        }
        return builder.length() == 0 ? null : builder.toString();
    }

    private void appendKeyTerm(StringBuilder builder, Vertex bnode, URI predicate) {
        if (bnode.getValue(predicate) != null) {
            builder.append('|');
            builder.append(predicate.stringValue());
        }
    }

    private void appendKey(StringBuilder builder, Vertex bnode, URI predicate) {
        Value value = bnode.getValue(predicate);
        if (value != null) {
            builder.append(predicate.stringValue());
            builder.append('|');
            builder.append(value.stringValue());
        }
    }

    private boolean containsValue(Value a, Set<Edge> sinkValues) {
        for (Edge edge : sinkValues) {
            Value b = edge.getObject();
            if (!a.equals(b)) continue;
            return true;
        }
        return false;
    }

    private void copyEdges(Set<Edge> sourceValues, Graph sink) {
        for (Edge e : sourceValues) {
            Edge f = sink.edge(e);
            if (!(f.getObject() instanceof BNode)) continue;
            Vertex object = sink.vertex((Resource)((BNode)f.getObject()));
            this.copy(object, sink);
        }
    }

    private void copy(Vertex v, Graph sink) {
        Set<Edge> out = v.outEdgeSet();
        this.copyEdges(out, sink);
    }
}

