/*
 * Decompiled with CFR 0.152.
 */
package io.konig.rio.turtle;

import io.konig.core.Context;
import io.konig.core.util.IriTemplate;
import io.konig.rio.turtle.IriTemplateParseException;
import io.konig.rio.turtle.SeaTurtleParser;
import java.io.IOException;
import java.io.Reader;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class IriTemplateParser {
    public static final IriTemplateParser INSTANCE = new IriTemplateParser();

    public IriTemplate parse(Reader reader) throws IriTemplateParseException {
        Worker worker = new Worker(reader);
        try {
            return worker.parse();
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new IriTemplateParseException(e);
        }
    }

    private static class Worker
    extends SeaTurtleParser {
        public Worker(Reader reader) {
            this.initParse(reader, "");
        }

        public IriTemplate parse() throws IOException, RDFParseException, RDFHandlerException {
            int c = this.next();
            Context context = null;
            if (c == 64) {
                if (this.tryWord("context")) {
                    this.contextTermList();
                    context = this.getContext();
                } else {
                    this.fail("Expected '@context'");
                }
            } else {
                this.unread(c);
            }
            String text = this.iriRef();
            return new IriTemplate(context, text);
        }
    }
}

