/*
 * Decompiled with CFR 0.152.
 */
package io.konig.rio.turtle;

import io.konig.core.Context;
import io.konig.core.NameMap;
import io.konig.core.Term;
import io.konig.core.impl.BasicContext;
import io.konig.core.impl.ChainedContext;
import io.konig.rio.turtle.ContextHandler;
import io.konig.rio.turtle.NamespaceMap;
import io.konig.rio.turtle.TurtleParser;
import java.io.IOException;
import java.io.Reader;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class SeaTurtleParser
extends TurtleParser {
    private Context defaultContext;
    private Context currentContext;
    private ContextHandler contextHandler;
    private Term lastTerm = null;
    private Term predicateTerm = null;
    protected NameMap nameMap;
    private NamespaceMap defaultNamespaceMap;

    public SeaTurtleParser() {
        this(null);
    }

    public SeaTurtleParser(NamespaceMap map) {
        super(null, (ValueFactory)ValueFactoryImpl.getInstance());
        this.defaultNamespaceMap = map;
        this.currentContext = this.defaultContext = new ChainedContext(null, new BasicContext(null));
        this.namespaceMap = new ContextNamespaceMap();
        this.setValueFactory((ValueFactory)new CoercingValueFactory());
    }

    public NamespaceMap getDefaultNamespaceMap() {
        return this.defaultNamespaceMap;
    }

    public void setDefaultNamespaceMap(NamespaceMap defaultNamespaceMap) {
        this.defaultNamespaceMap = defaultNamespaceMap;
    }

    public NameMap getNameMap() {
        return this.nameMap;
    }

    public void setNameMap(NameMap nameMap) {
        this.nameMap = nameMap;
    }

    @Override
    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        super.parse(reader, baseURI);
    }

    @Override
    protected void initParse(Reader reader, String baseURI) {
        super.initParse(reader, baseURI);
        this.currentContext = this.defaultContext;
    }

    public ContextHandler getContextHandler() {
        return this.contextHandler;
    }

    public void setContextHandler(ContextHandler contextHandler) {
        this.contextHandler = contextHandler;
    }

    protected void prologue() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.next();
        while (c == 64) {
            this.directive(c);
            c = this.next();
        }
        this.unread(c);
    }

    @Override
    protected void directive(int c) throws IOException, RDFParseException, RDFHandlerException {
        if (this.tryWord("prefix")) {
            this.prefixID();
        } else if (this.tryWord("context")) {
            this.contextTermList();
        } else if (this.tryWord("base")) {
            this.base();
        } else if (this.tryWord("term")) {
            this.termDirective();
        }
    }

    private void termDirective() throws RDFParseException, IOException, RDFHandlerException {
        this.skipSpace();
        String termName = this.pn_local();
        String idValue = null;
        int c = this.next();
        if (c == 60) {
            idValue = this.iriRef(c);
        } else {
            this.unread(c);
            String prefix = this.pn_prefix();
            c = this.read();
            if (c == 58) {
                String local = this.pn_local();
                idValue = prefix + ':' + local;
            } else {
                this.fail("Expected fully-qualified IRI or CURIE");
            }
        }
        Context context = this.getContext();
        context.add(new Term(termName, idValue));
    }

    protected void contextTermList() throws IOException, RDFParseException {
        this.assertNext(123);
        Context parentContext = this.currentContext;
        BasicContext context = new BasicContext(null);
        this.currentContext = new ChainedContext(parentContext, context);
        Term term = this.term();
        context.add(term);
        int c = this.next();
        while (c == 44) {
            term = this.term();
            context.add(term);
            c = this.next();
        }
        this.assertEquals(125, c);
        this.currentContext.compile();
        if (this.contextHandler != null) {
            this.contextHandler.addContext((ChainedContext)this.currentContext);
        }
    }

    @Override
    protected URI prefixedName(int c) throws IOException, RDFParseException {
        Term term;
        this.unread(c);
        String prefix = this.pn_prefix();
        c = this.read();
        if (c != 58) {
            this.unread(c);
            this.defaultContext.compile();
            Term term2 = this.lastTerm = this.currentContext.getTerm(prefix);
            if (term2 == null) {
                URI result;
                if (this.nameMap != null && (result = this.nameMap.get(prefix)) != null) {
                    return result;
                }
                StringBuilder err = this.err();
                err.append("Term not defined: ");
                err.append(prefix);
                this.fail(err);
            }
            return term2.getExpandedId();
        }
        String localName = this.pn_local();
        String namespace = this.namespaceMap.get(prefix);
        if (namespace == null && (term = this.currentContext.getTerm(prefix)) != null) {
            this.defaultContext.compile();
            namespace = term.getExpandedIdValue();
        }
        if (namespace == null) {
            this.fail("Namespace not defined for prefix '" + prefix + "'");
        }
        return this.valueFactory.createURI(namespace + localName);
    }

    private Term term() throws IOException, RDFParseException {
        String termName = this.termName();
        this.assertNext(58);
        this.readSpace();
        return this.termDefinition(termName);
    }

    private String termName() throws RDFParseException, IOException {
        return this.jsonString();
    }

    private String jsonString() throws RDFParseException, IOException {
        this.assertNext(34);
        this.buffer();
        while (this.jsonChar()) {
        }
        String result = this.buffer.toString();
        this.assertNext(34);
        return result;
    }

    private boolean jsonChar() throws IOException, RDFParseException {
        boolean ok;
        int c = this.read();
        boolean bl = ok = this.unescapedJsonChar(c) || this.escapedJsonChar(c);
        if (!ok) {
            this.unread(c);
        }
        return ok;
    }

    private boolean escapedJsonChar(int c) throws IOException, RDFParseException {
        if (c == 92) {
            c = this.read();
            switch (c) {
                case 47: 
                case 92: 
                case 98: 
                case 102: 
                case 110: 
                case 114: 
                case 116: {
                    this.buffer.appendCodePoint(c);
                    break;
                }
                case 117: {
                    String hexString = new String(new char[]{this.hex(), this.hex(), this.hex(), this.hex()});
                    this.buffer.appendCodePoint(Integer.parseInt(hexString, 16));
                    break;
                }
                default: {
                    this.fail("Invalid escape character.  Expected '\\\"', '\\\\', '\\/', '\\b', '\\f', '\\n', '\\r', '\\t' or '\\u' hex hex hex .");
                }
            }
            return true;
        }
        return false;
    }

    private boolean unescapedJsonChar(int c) {
        if (this.inRange(c, 32, 33) || this.inRange(c, 35, 91) || this.inRange(c, 93, 0x10FFFF)) {
            this.buffer.appendCodePoint(c);
            return true;
        }
        return false;
    }

    private Term termDefinition(String termName) throws IOException, RDFParseException {
        Term term = null;
        int c = this.peek();
        if (c == 34) {
            String idValue = this.jsonString();
            term = new Term(termName, idValue, Term.Kind.ANY);
        } else if (c == 123) {
            term = this.expandedTermDefinition(termName);
        }
        return term;
    }

    protected Context getContext() {
        return this.currentContext;
    }

    private Term expandedTermDefinition(String termName) throws RDFParseException, IOException {
        String id = null;
        String type = null;
        String language = null;
        this.assertNext(123);
        while (true) {
            String keyword;
            switch (keyword = this.jsonString()) {
                case "@id": {
                    this.assertNext(58);
                    id = this.jsonString();
                    break;
                }
                case "@type": {
                    this.assertNext(58);
                    type = this.jsonString();
                    break;
                }
                case "@language": {
                    this.assertNext(58);
                    language = this.jsonString();
                    break;
                }
                default: {
                    StringBuilder err = this.err();
                    err.append("JSON-LD keyword not supported: ");
                    err.append(keyword);
                    this.fail(err);
                }
            }
            int c = this.next();
            if (c == 125) break;
            if (c == 44) continue;
            this.fail("Expected ',' or '}'");
        }
        return new Term(termName, id, language, type);
    }

    @Override
    protected URI iri(int c) throws RDFParseException, IOException, RDFHandlerException {
        if (c == 60) {
            String text = this.iriRef(c);
            return this.valueFactory.createURI(text);
        }
        if (c == 123) {
            return this.iriPropertyList(c);
        }
        return this.prefixedName(c);
    }

    protected URI iriPropertyList() throws RDFParseException, RDFHandlerException, IOException {
        this.read('{');
        return this.iriPropertyList(123);
    }

    @Override
    protected Value object(int c) throws RDFParseException, IOException, RDFHandlerException {
        if (c == 123) {
            this.unread(c);
            return this.iriPropertyList();
        }
        return super.object(c);
    }

    private URI iriPropertyList(int c) throws RDFParseException, IOException, RDFHandlerException {
        this.assertEquals(123, c);
        Context initialContext = this.currentContext;
        URI id = null;
        c = this.next();
        while (c == 64) {
            if (this.tryWord("context")) {
                if (id != null) {
                    this.fail("@context must come before @id");
                }
                this.contextTermList();
            } else if (this.tryWord("id")) {
                id = this.iri(this.next());
            } else {
                this.fail("Expected '@context' or '@id'");
            }
            c = this.next();
        }
        if (id == null) {
            this.fail("@id property must be defined.");
        }
        if (c == 59) {
            this.predicateObjectList((Resource)id);
            this.assertNext(125);
        } else {
            this.assertEquals(125, c);
        }
        if (this.currentContext != initialContext) {
            ChainedContext chain = (ChainedContext)this.currentContext;
            this.currentContext = chain.getParent();
            if (this.contextHandler != null) {
                this.contextHandler.removeContext(chain);
            }
        }
        return id;
    }

    @Override
    protected URI verb() throws IOException, RDFParseException, RDFHandlerException {
        this.lastTerm = null;
        URI result = super.verb();
        this.predicateTerm = this.lastTerm;
        return result;
    }

    @Override
    protected void triples(int c) throws RDFParseException, IOException, RDFHandlerException {
        BNode subject = null;
        if (c == 91) {
            subject = this.tryBlankNodePropertyList(c);
            if (subject != null) {
                c = this.next();
                this.unread(c);
                if (c != 46) {
                    this.predicateObjectList((Resource)subject);
                }
                return;
            }
        } else if (c == 123) {
            subject = this.iriPropertyList(c);
            c = this.next();
            this.unread(c);
            if (c != 46) {
                this.predicateObjectList((Resource)subject);
            }
            return;
        }
        subject = this.subject(c);
        this.predicateObjectList((Resource)subject);
    }

    private class CoercingValueFactory
    extends ValueFactoryImpl {
        private CoercingValueFactory() {
        }

        public Literal createLiteral(String value, URI datatype) {
            String lang;
            if (SeaTurtleParser.this.predicateTerm != null) {
                SeaTurtleParser.this.currentContext.compile();
                lang = SeaTurtleParser.this.predicateTerm.getLanguage();
                if (lang != null) {
                    return super.createLiteral(value, lang);
                }
                URI type = SeaTurtleParser.this.predicateTerm.getExpandedType();
                if (type != null) {
                    datatype = type;
                }
            }
            if ((lang = SeaTurtleParser.this.currentContext.getLanguage()) != null && XMLSchema.STRING.equals((Object)datatype)) {
                return super.createLiteral(value, lang);
            }
            return super.createLiteral(value, datatype);
        }
    }

    private class ContextNamespaceMap
    implements NamespaceMap {
        private ContextNamespaceMap() {
        }

        @Override
        public String get(String prefix) {
            SeaTurtleParser.this.defaultContext.compile();
            Term term = SeaTurtleParser.this.currentContext.getTerm(prefix);
            return term != null ? term.getExpandedIdValue() : (SeaTurtleParser.this.defaultNamespaceMap != null ? SeaTurtleParser.this.defaultNamespaceMap.get(prefix) : null);
        }

        @Override
        public void put(String prefix, String name) {
            SeaTurtleParser.this.defaultContext.addTerm(prefix, name).setKind(Term.Kind.NAMESPACE);
        }
    }
}

