/*
 * Decompiled with CFR 0.152.
 */
package io.konig.rio.turtle;

import io.konig.core.util.IriTemplate;
import io.konig.rio.turtle.HashNamespaceMap;
import io.konig.rio.turtle.NamespaceMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFParserBase;

public class TurtleParser
extends RDFParserBase {
    private static final int PUSH_BACK_SIZE = 20;
    protected PushbackReader reader;
    protected StringBuilder buffer = new StringBuilder();
    private String baseURI;
    private int lineNumber = 1;
    private int columnNumber;
    protected NamespaceMap namespaceMap;

    public TurtleParser() {
        this.namespaceMap = new HashNamespaceMap();
    }

    public TurtleParser(NamespaceMap namespaceMap) {
        this.namespaceMap = namespaceMap == null ? new HashNamespaceMap() : namespaceMap;
    }

    public TurtleParser(NamespaceMap namespaceMap, ValueFactory valueFactory) {
        super(valueFactory);
        this.namespaceMap = namespaceMap;
    }

    protected StringBuilder buffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    protected String nextWord(String delim) throws IOException {
        int c;
        this.skipSpace();
        StringBuilder buffer = this.buffer();
        while ((c = this.read()) != -1) {
            if (delim.lastIndexOf(c) >= 0) {
                this.unread(c);
                break;
            }
            buffer.appendCodePoint(c);
        }
        return buffer.toString();
    }

    public NamespaceMap getNamespaceMap() {
        return this.namespaceMap;
    }

    private void turtleDoc() throws IOException, RDFParseException, RDFHandlerException {
        this.lineNumber = 1;
        this.columnNumber = 0;
        if (this.rdfHandler != null) {
            this.rdfHandler.startRDF();
        }
        int c = 0;
        while (c != -1) {
            this.statement();
            c = this.next();
            this.unread(c);
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    private void statement() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.next();
        if (c == 64) {
            this.directive(c);
        } else {
            this.triples(c);
            this.read('.');
        }
    }

    protected void directive(int c) throws IOException, RDFParseException, RDFHandlerException {
        if (this.tryWord("prefix")) {
            this.prefixID();
        } else if (this.tryWord("base")) {
            this.base();
        }
    }

    protected void base() throws RDFParseException {
        this.fail("@base directive is not supported");
    }

    protected void prefixID() throws RDFParseException, IOException, RDFHandlerException {
        this.readSpace();
        String prefix = this.pname_ns();
        String iriRef = this.iriRef(this.next());
        this.read('.');
        this.namespaceMap.put(prefix, iriRef);
        this.namespace(prefix, iriRef);
    }

    protected void namespace(String prefix, String name) throws RDFHandlerException {
        if (this.rdfHandler != null) {
            this.rdfHandler.handleNamespace(prefix, name);
        }
    }

    protected String pname_ns() throws IOException, RDFParseException {
        StringBuilder builder = this.buffer();
        int c = this.next();
        this.pn_prefix(c);
        c = this.next();
        if (c != 58) {
            builder = this.err();
            builder.append("Expected ':' but found '");
            this.appendCodePoint(builder, c);
            builder.append("'");
            this.fail(builder);
        }
        return builder.toString();
    }

    protected String pn_prefix() throws RDFParseException, IOException {
        this.buffer();
        int c = this.next();
        this.pn_prefix(c);
        return this.buffer.toString();
    }

    protected void pn_prefix(int c) throws IOException, RDFParseException {
        if (this.pn_chars_base(c)) {
            this.buffer.appendCodePoint(c);
            boolean endsWithDot = false;
            while (true) {
                if (this.pn_chars(c = this.read())) {
                    this.buffer.appendCodePoint(c);
                    endsWithDot = false;
                    continue;
                }
                if (c != 46) break;
                this.buffer.appendCodePoint(c);
                endsWithDot = true;
            }
            if (endsWithDot) {
                throw new RDFParseException("Namespace prefix cannot end with '.'");
            }
        }
        this.unread(c);
    }

    protected boolean pn_chars(int c) {
        return this.pn_chars_u(c) || c == 45 || this.inRange(c, 48, 57) || c == 183 || this.inRange(c, 768, 879) || this.inRange(c, 8255, 8256);
    }

    protected boolean pn_chars_u(int c) {
        return this.pn_chars_base(c) || c == 95;
    }

    protected boolean pn_chars_base(int c) {
        return this.inRange(c, 65, 90) || this.inRange(c, 97, 122) || this.inRange(c, 192, 214) || this.inRange(c, 216, 246) || this.inRange(c, 248, 767) || this.inRange(c, 880, 893) || this.inRange(c, 895, 8191) || this.inRange(c, 8204, 8205) || this.inRange(c, 8304, 8591) || this.inRange(c, 11264, 12271) || this.inRange(c, 12289, 55295) || this.inRange(c, 63744, 64975) || this.inRange(c, 65008, 65533) || this.inRange(c, 65536, 983039);
    }

    protected boolean inRange(int c, int min, int max) {
        return c >= min && c <= max;
    }

    protected void readSpace() throws IOException, RDFParseException {
        int c = this.read();
        if (!this.isWhitespace(c)) {
            StringBuilder err = this.err();
            err.append("Expected whitespace but found '");
            this.appendCodePoint(err, c);
            err.append("'");
            this.fail(err);
        }
        this.skipSpace();
    }

    protected boolean skipSpace() throws IOException {
        boolean result = false;
        int c = this.read();
        while (this.isWhitespace(c)) {
            result = true;
            c = this.read();
        }
        this.unread(c);
        return result;
    }

    protected void triples(int c) throws RDFParseException, IOException, RDFHandlerException {
        BNode subject;
        boolean done = false;
        if (c == 91 && (subject = this.tryBlankNodePropertyList(c)) != null) {
            done = true;
            c = this.next();
            this.unread(c);
            if (c != 46) {
                this.predicateObjectList((Resource)subject);
            }
        }
        if (!done) {
            subject = this.subject(c);
            this.predicateObjectList((Resource)subject);
        }
    }

    protected void predicateObjectList(Resource subject) throws IOException, RDFParseException, RDFHandlerException {
        URI predicate = this.verb();
        this.objectList(subject, predicate);
        int c = this.next();
        while (c == 59) {
            predicate = this.verb();
            this.objectList(subject, predicate);
            c = this.next();
        }
        this.unread(c);
    }

    private void objectList(Resource subject, URI predicate) throws IOException, RDFHandlerException, RDFParseException {
        int c = this.next();
        Value object = this.object(c);
        this.statement(subject, predicate, object);
        c = this.next();
        while (c == 44) {
            c = this.next();
            object = this.object(c);
            this.statement(subject, predicate, object);
            c = this.next();
        }
        this.unread(c);
    }

    protected void statement(Resource subject, URI predicate, Value object) throws RDFHandlerException {
        if (this.rdfHandler != null) {
            Statement st = this.valueFactory.createStatement(subject, predicate, object);
            this.rdfHandler.handleStatement(st);
        }
    }

    protected Value object(int c) throws RDFParseException, IOException, RDFHandlerException {
        Value value = null;
        value = this.tryCollection(c);
        Object object = value != null ? value : ((value = this.tryLiteral(c)) != null ? value : ((value = this.tryBlankNode(c)) != null ? value : ((value = this.tryBlankNodePropertyList(c)) != null ? value : (value = (value = this.tryIri(c)) != null ? value : null))));
        if (value == null) {
            this.fail("Expected (iri | BlankNode | collection | blankNodePropertyList | literal)");
        }
        return value;
    }

    private Value tryCollection(int c) {
        return null;
    }

    protected BNode blankNodePropertyList() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.read();
        BNode result = this.tryBlankNodePropertyList(c);
        if (result == null) {
            this.unread(c);
        }
        return result;
    }

    protected BNode tryBlankNodePropertyList(int c) throws IOException, RDFParseException, RDFHandlerException {
        if (c != 91) {
            return null;
        }
        c = this.next();
        this.unread(c);
        if (c == 93) {
            return null;
        }
        BNode bnode = this.valueFactory.createBNode();
        this.predicateObjectList((Resource)bnode);
        c = this.next();
        if (c != 93) {
            StringBuilder builder = this.err();
            builder.append("Expected ']' but found '");
            this.appendCodePoint(builder, c);
            builder.append("'");
            this.fail(builder);
        }
        return bnode;
    }

    protected void appendCodePoint(StringBuilder builder, int c) {
        if (c == -1) {
            builder.append("<<EOF>>");
        } else {
            builder.appendCodePoint(c);
        }
    }

    protected Literal tryLiteral() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.read();
        Literal literal = this.tryLiteral(c);
        if (literal == null) {
            this.unread(c);
        }
        return literal;
    }

    private Literal tryLiteral(int c) throws IOException, RDFParseException, RDFHandlerException {
        Literal value = null;
        value = this.tryRDFLiteral(c);
        value = value != null ? value : ((value = this.tryNumericLiteral(c)) != null ? value : ((value = this.tryBooleanLiteral(c)) != null ? value : null));
        return value;
    }

    private Literal tryBooleanLiteral(int c) throws IOException {
        Literal result = null;
        if (c == 116 && this.tryWord("rue")) {
            result = this.valueFactory.createLiteral(true);
        } else if (c == 102 && this.tryWord("alse")) {
            result = this.valueFactory.createLiteral(false);
        }
        if (result != null) {
            c = this.read();
            this.unread(c);
            if (!this.isWhitespace(c) && c != 44 && c != 59 && c != 46 && c != 47 && c != 94 && c != 93) {
                boolean value = result.booleanValue();
                if (value) {
                    this.unread("rue");
                } else {
                    this.unread("alse");
                }
                result = null;
            }
        }
        return result;
    }

    protected void unread(String text) throws IOException {
        for (int i = text.length() - 1; i >= 0; --i) {
            this.unread(text.charAt(i));
        }
    }

    private Literal tryNumericLiteral(int c) throws IOException, RDFParseException {
        Literal result = null;
        boolean digit = this.isDigit(c);
        if (!digit && c != 43 && c != 45 && c != 46) {
            return null;
        }
        StringBuilder builder = this.buffer();
        if (c == 43 || c == 45) {
            builder.appendCodePoint(c);
            c = this.read();
            digit = this.isDigit(c);
        }
        if (digit) {
            result = this.numberWithIntegerPart(c);
        } else if (c == 46) {
            result = this.tryDecimalPart(c);
        } else {
            builder = this.err();
            builder.append("Invalid numeric literal. Expected [0-9] or '.' but found '");
            builder.appendCodePoint(c);
            builder.append("'");
            this.fail(builder);
        }
        return result;
    }

    private Literal tryDecimalPart(int c) throws IOException, RDFParseException {
        Literal result = null;
        if (c == 46) {
            c = this.read();
            if (c == 101 | c == 69) {
                this.buffer.append('.');
                result = this.tryExponent(c);
            } else if (this.isDigit(c)) {
                this.buffer.append('.');
                while (this.isDigit(c)) {
                    this.buffer.appendCodePoint(c);
                    c = this.read();
                }
                result = this.tryExponent(c);
                if (result == null) {
                    this.unread(c);
                    result = this.valueFactory.createLiteral(this.buffer.toString(), XMLSchema.DECIMAL);
                }
            }
            if (result == null) {
                this.unread(c);
            }
        }
        return result;
    }

    private Literal numberWithIntegerPart(int c) throws RDFParseException, IOException {
        while (this.isDigit(c)) {
            this.buffer.appendCodePoint(c);
            c = this.read();
        }
        Literal result = this.tryDecimalPart(c);
        result = result != null ? result : ((result = this.tryExponent(c)) != null ? result : this.integerLiteral(c));
        return result;
    }

    private Literal integerLiteral(int c) throws IOException {
        this.unread(c);
        return this.valueFactory.createLiteral(this.buffer.toString(), XMLSchema.INTEGER);
    }

    private Literal tryExponent(int c) throws IOException, RDFParseException {
        Literal result = null;
        if (c == 101 || c == 69) {
            this.buffer.appendCodePoint(c);
            c = this.read();
            if (c == 43 || c == 45) {
                this.buffer.appendCodePoint(c);
                c = this.read();
            }
            if (!this.isDigit(c)) {
                this.unread(c);
                return null;
            }
            while (this.isDigit(c)) {
                this.buffer.appendCodePoint(c);
                c = this.read();
            }
            this.unread(c);
            result = this.valueFactory.createLiteral(this.buffer.toString(), XMLSchema.DOUBLE);
        }
        return result;
    }

    protected boolean isLetter(int c) {
        return this.inRange(c, 97, 122) || this.inRange(c, 65, 90);
    }

    protected boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private Literal tryRDFLiteral(int c) throws RDFParseException, IOException, RDFHandlerException {
        Literal result = null;
        if (c == 39 || c == 34) {
            return this.rdfLiteral(c);
        }
        return result;
    }

    private Literal rdfLiteral(int c) throws IOException, RDFParseException, RDFHandlerException {
        Literal result = null;
        this.string(c, this.buffer());
        c = this.read();
        String text = this.buffer.toString();
        if (c == 64) {
            String lang = this.langtag(c);
            result = this.valueFactory.createLiteral(text, lang);
        } else if (c == 94) {
            c = this.read();
            if (c != 94) {
                this.err();
                this.buffer.append("Invalid string literal. Expected '^^' but found '^");
                this.buffer.appendCodePoint(c);
                this.buffer.append("'");
                this.fail(this.buffer);
            }
            c = this.read();
            result = this.valueFactory.createLiteral(text, this.iri(c));
        } else {
            this.unread(c);
            result = this.valueFactory.createLiteral(text, XMLSchema.STRING);
        }
        return result;
    }

    private String langtag(int c) throws RDFParseException, IOException {
        if (c != 64) {
            this.err();
            this.buffer.append("Expected '@' but found '");
            this.buffer.appendCodePoint(c);
            this.buffer.append("'");
            this.fail(this.buffer);
        }
        this.buffer();
        c = this.read();
        if (!this.inRange(c, 97, 122) && !this.inRange(c, 65, 90)) {
            this.err();
            this.buffer.append("Language tag must start with a letter, but found '");
            this.buffer.appendCodePoint(c);
            this.buffer.append("'");
            this.fail(this.buffer);
        }
        while (this.inRange(c, 97, 122) || this.inRange(c, 65, 90) || this.isDigit(c) || c == 45) {
            this.buffer.appendCodePoint(c);
            c = this.read();
        }
        this.unread(c);
        return this.buffer.toString();
    }

    private void string(int c, StringBuilder builder) throws RDFParseException, IOException {
        if (c != 39 && c != 34) {
            this.err();
            this.buffer.append("Expected ['] or [\"] but found [");
            this.buffer.appendCodePoint(c);
            this.buffer.append("'");
            this.fail(this.buffer);
        }
        int d = this.read();
        int e = this.read();
        if (c == 39) {
            if (d == 39 && e == 39) {
                this.string_literal_long_single_quote(c, d, e, builder);
            } else {
                this.unread(e);
                this.unread(d);
                this.string_literal_single_quote(c, builder);
            }
        } else if (d == 34 && e == 34) {
            this.string_literal_long_quote(c, d, e, builder);
        } else {
            this.unread(e);
            this.unread(d);
            this.string_literal_quote(c, builder);
        }
    }

    private void string_literal_quote(int c, StringBuilder builder) throws RDFParseException, IOException {
        this.assertEquals(34, c);
        while (this.stringQuoteChar(c = this.read(), builder)) {
        }
        this.assertEquals(34, c);
    }

    protected void assertEqualsIgnoreCase(int expected, int actual) throws RDFParseException {
        if (Character.toUpperCase(expected) != Character.toUpperCase(actual)) {
            StringBuilder err = this.err();
            int lower = Character.toLowerCase(expected);
            int upper = Character.toUpperCase(expected);
            err.append("Expected '");
            err.appendCodePoint(lower);
            err.append("' or '");
            err.appendCodePoint(upper);
            err.append("' but found '");
            this.appendCodePoint(err, actual);
            err.append("'");
            this.fail(err);
        }
    }

    protected void assertIgnoreCase(String expected) throws IOException, RDFParseException {
        int c;
        for (int i = 0; i < expected.length(); i += Character.charCount(c)) {
            c = expected.codePointAt(i);
            int d = this.read();
            this.assertEqualsIgnoreCase(c, d);
        }
    }

    protected void assertEquals(int expected, int actual) throws RDFParseException {
        if (actual != expected) {
            this.err();
            if (actual == 39) {
                this.buffer.append("Expected [");
                this.buffer.appendCodePoint(expected);
                this.buffer.append("] but found [");
                if (actual == -1) {
                    this.buffer.append("EOF");
                } else {
                    this.buffer.appendCodePoint(actual);
                }
                this.buffer.append("]");
            } else {
                this.buffer.append("Expected '");
                this.buffer.appendCodePoint(expected);
                this.buffer.append("' but found '");
                if (actual == -1) {
                    this.buffer.append("EOF");
                } else {
                    this.buffer.appendCodePoint(actual);
                }
                this.buffer.append("'");
            }
            this.fail(this.buffer);
        }
    }

    protected void assertNext(int expected) throws IOException, RDFParseException {
        int actual = this.next();
        this.assertEquals(expected, actual);
    }

    protected void assertWhitespace() throws IOException, RDFParseException {
        int c = this.read();
        if (!this.isWhitespace(c)) {
            this.fail("Expected whitespace");
        }
        this.skipSpace();
    }

    private boolean stringQuoteChar(int c, StringBuilder builder) throws IOException, RDFParseException {
        if (this.echar(c, builder) || this.uchar(c, builder)) {
            return true;
        }
        if (c != 34 && c != 92 && c != 10 && c != 13) {
            builder.appendCodePoint(c);
            return true;
        }
        return false;
    }

    private boolean echar(int c, StringBuilder builder) throws IOException {
        if (c == 92) {
            int d = this.read();
            switch (d) {
                case 116: {
                    builder.append('\t');
                    return true;
                }
                case 98: {
                    builder.append('\b');
                    return true;
                }
                case 110: {
                    builder.append('\n');
                    return true;
                }
                case 114: {
                    builder.append('\r');
                    return true;
                }
                case 102: {
                    builder.append('\f');
                    return true;
                }
                case 34: {
                    builder.append('\"');
                    return true;
                }
                case 39: {
                    builder.append('\'');
                    return true;
                }
                case 92: {
                    builder.append('\\');
                    return true;
                }
            }
            this.unread(d);
        }
        return false;
    }

    private boolean uchar(int c, StringBuilder builder) throws RDFParseException, IOException {
        if (c == 92) {
            char[] tmp;
            c = this.read();
            if (c != 117 && c != 85) {
                this.unread(c);
                return false;
            }
            char[] array = null;
            if (c == 117) {
                array = tmp = new char[]{this.hex(), this.hex(), this.hex(), this.hex()};
            } else if (c == 85) {
                array = tmp = new char[]{this.hex(), this.hex(), this.hex(), this.hex(), this.hex(), this.hex(), this.hex(), this.hex()};
            }
            String value = new String(array);
            c = Integer.parseInt(value, 16);
            builder.appendCodePoint(c);
            return true;
        }
        return false;
    }

    private void string_literal_long_quote(int c, int d, int e, StringBuilder builder) throws RDFParseException, IOException {
        this.assertEquals(34, c);
        this.assertEquals(34, d);
        this.assertEquals(34, e);
        while (this.stringLongQuoteChar(c = this.read(), builder)) {
        }
        this.assertEquals(34, c);
        this.read('\"');
        this.read('\"');
    }

    private boolean stringLongSingleQuoteChar(int c, StringBuilder builder) throws RDFParseException, IOException {
        if (c == 39) {
            return this.quoteChar('\'', builder);
        }
        if (this.echar(c, builder) || this.uchar(c, builder)) {
            return true;
        }
        if (c != 92) {
            builder.appendCodePoint(c);
            return true;
        }
        return false;
    }

    private boolean stringLongQuoteChar(int c, StringBuilder builder) throws RDFParseException, IOException {
        if (c == 34) {
            return this.quoteChar('\"', builder);
        }
        if (this.echar(c, builder) || this.uchar(c, builder)) {
            return true;
        }
        if (c != 92) {
            builder.appendCodePoint(c);
            return true;
        }
        return false;
    }

    private boolean quoteChar(char q, StringBuilder builder) throws IOException {
        int d = this.read();
        if (d != q) {
            this.unread(d);
            builder.append(q);
            return true;
        }
        int e = this.read();
        if (e != q) {
            this.unread(e);
            builder.append(q);
            builder.append(q);
            return true;
        }
        this.unread(q);
        this.unread(q);
        return false;
    }

    private void string_literal_single_quote(int c, StringBuilder builder) throws RDFParseException, IOException {
        this.assertEquals(39, c);
        while (this.stringSingleQuoteChar(c = this.read(), builder)) {
        }
        this.assertEquals(39, c);
    }

    private boolean stringSingleQuoteChar(int c, StringBuilder builder) throws RDFParseException, IOException {
        if (this.echar(c, builder) || this.uchar(c, builder)) {
            return true;
        }
        if (c != 39 && c != 92 && c != 10 && c != 13) {
            builder.appendCodePoint(c);
            return true;
        }
        return false;
    }

    private void string_literal_long_single_quote(int c, int d, int e, StringBuilder builder) throws RDFParseException, IOException {
        int q = 39;
        this.assertEquals(39, c);
        this.assertEquals(39, d);
        this.assertEquals(39, e);
        while (this.stringLongSingleQuoteChar(c = this.read(), builder)) {
        }
        this.assertEquals(39, c);
        this.read('\'');
        this.read('\'');
    }

    private BNode tryBlankNode(int c) throws RDFParseException, IOException {
        BNode bnode = null;
        bnode = this.blank_node_label(c);
        return bnode == null ? this.anon(c) : bnode;
    }

    private BNode anon(int c) throws IOException {
        if (c != 91) {
            return null;
        }
        c = this.next();
        if (c != 93) {
            this.unread(c);
            return null;
        }
        return this.valueFactory.createBNode();
    }

    private BNode blank_node_label(int c) throws IOException, RDFParseException {
        StringBuilder builder;
        if (c != 95) {
            return null;
        }
        c = this.read();
        if (c != 58) {
            this.unread(c);
            return null;
        }
        c = this.read();
        if (!this.pn_chars_u(c) && !this.inRange(c, 48, 57)) {
            builder = this.err();
            builder.append("Invalid initial character for BNode label: '");
            builder.appendCodePoint(c);
            builder.append("'");
            this.fail(builder);
        }
        builder = this.buffer();
        builder.appendCodePoint(c);
        int last = -1;
        while (this.pn_chars(c = this.read()) || c == 46) {
            builder.appendCodePoint(c);
            last = c;
        }
        this.unread(c);
        if (last == 46) {
            this.unread(last);
        }
        return this.valueFactory.createBNode(builder.toString());
    }

    private URI tryIri(int c) {
        int saveLineNumber = this.lineNumber;
        int saveColumnNo = this.columnNumber;
        try {
            return this.iri(c);
        }
        catch (Throwable oops) {
            this.lineNumber = saveLineNumber;
            this.columnNumber = saveColumnNo;
            return null;
        }
    }

    protected URI verb() throws IOException, RDFParseException, RDFHandlerException {
        int c = this.next();
        if (c == 97) {
            int cc = this.read();
            if (this.isWhitespace(cc)) {
                return RDF.TYPE;
            }
            this.unread(cc);
        }
        return this.iri(c);
    }

    protected Resource subject(int c) throws RDFParseException, IOException, RDFHandlerException {
        BNode result = null;
        if (c == 95 || c == 91) {
            result = this.tryBlankNode(c);
            if (result == null) {
                this.fail("Invalid BNode definition");
            }
        } else if (c == 40) {
            this.fail("TODO: Implement collection");
        } else {
            result = this.iri(c);
        }
        if (result == null) {
            StringBuilder msg = this.err();
            msg.append("Found '");
            msg.appendCodePoint(c);
            msg.append("' but expected (iri | BlankNode | collection)");
            this.fail(msg);
        }
        return result;
    }

    protected URI iri() throws RDFParseException, IOException, RDFHandlerException {
        return this.iri(this.read());
    }

    protected URI iri(int c) throws RDFParseException, IOException, RDFHandlerException {
        if (c == 60) {
            String text = this.iriRef(c);
            return this.valueFactory.createURI(text);
        }
        return this.prefixedName(c);
    }

    protected URI prefixedName(int c) throws IOException, RDFParseException {
        this.unread(c);
        String prefix = this.pname_ns();
        String localName = this.pn_local();
        String namespace = this.namespaceMap.get(prefix);
        if (namespace == null) {
            this.fail("Namespace not defined for prefix '" + prefix + "'");
        }
        return this.valueFactory.createURI(namespace + localName);
    }

    public String pn_local() throws IOException, RDFParseException {
        StringBuilder builder = this.buffer();
        int c = this.read();
        if (!(this.pn_chars_u(c) || c == 58 || this.inRange(c, 48, 57) || this.plx(c))) {
            this.unread(c);
        } else {
            builder.appendCodePoint(c);
            int last = -1;
            while (this.pn_chars(c = this.read()) || c == 46 || c == 58 || this.plx(c)) {
                builder.appendCodePoint(c);
                last = c;
            }
            this.unread(c);
            if (last == 46) {
                this.unread(c);
            }
        }
        return builder.toString();
    }

    protected boolean plx(int c) throws IOException, RDFParseException {
        return this.percent(c) || this.pn_local_esc(c);
    }

    private boolean pn_local_esc(int c) throws IOException {
        if (c != 92) {
            return false;
        }
        int next = this.read();
        switch (next) {
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 95: 
            case 126: {
                this.buffer.appendCodePoint(c);
                this.buffer.appendCodePoint(next);
                return true;
            }
        }
        this.unread(next);
        return false;
    }

    private boolean percent(int c) throws RDFParseException, IOException {
        if (c != 37) {
            return false;
        }
        char[] array = new char[]{this.hex(), this.hex()};
        String text = new String(array);
        c = Integer.parseInt(text, 16);
        this.buffer.appendCodePoint(c);
        return true;
    }

    protected IriTemplate iriTemplate() throws RDFParseException, IOException {
        int c = this.next();
        String text = this.iriRef(c);
        return new IriTemplate(text);
    }

    protected String iriRef() throws IOException, RDFParseException {
        this.skipSpace();
        int c = this.read();
        return this.iriRef(c);
    }

    protected String iriRef(int c) throws IOException, RDFParseException {
        this.assertEquals(60, c);
        StringBuilder builder = this.buffer();
        c = this.read();
        while (c != -1 && c != 62) {
            if (c == 92) {
                this.uchar();
            } else {
                builder.appendCodePoint(c);
            }
            c = this.read();
        }
        this.assertEquals(62, c);
        return builder.toString();
    }

    private void uchar() throws RDFParseException, IOException {
        char[] tmp;
        int c = this.read();
        char[] array = null;
        if (c == 117) {
            array = tmp = new char[]{this.hex(), this.hex(), this.hex(), this.hex()};
        } else if (c == 85) {
            array = tmp = new char[]{this.hex(), this.hex(), this.hex(), this.hex(), this.hex(), this.hex(), this.hex(), this.hex()};
        } else {
            StringBuilder builder = this.err();
            builder.append("Invalid escape sequence in IRI value. Expected (\\u HEX HEX HEX | \\U HEX HEX HEX HEX HEX HEX HEX HEX) but found: \\");
            builder.appendCodePoint(c);
            this.fail(builder);
        }
        String value = new String(array);
        c = Integer.parseInt(value, 16);
        this.buffer.appendCodePoint(c);
    }

    protected char hex() throws IOException, RDFParseException {
        int c = this.read();
        if (!(this.inRange(c, 97, 102) || this.inRange(c, 65, 70) || this.inRange(c, 48, 57))) {
            StringBuilder msg = this.err();
            msg.append("Invalid HEX value. Expected  [a-f] | [A-F] | [0-9] but found '");
            msg.appendCodePoint(c);
            msg.append("'");
            this.fail(msg);
        }
        return (char)c;
    }

    protected StringBuilder err() {
        this.buffer.setLength(0);
        this.buffer.append("Line ");
        this.buffer.append(this.lineNumber);
        if (this.columnNumber > 0) {
            this.buffer.append(':');
            this.buffer.append(this.columnNumber - 1);
        }
        this.buffer.append(' ');
        return this.buffer;
    }

    protected void fail(String msg) throws RDFParseException {
        StringBuilder builder = this.err();
        builder.append(msg);
        this.fail(builder);
    }

    protected void fail(StringBuilder builder) throws RDFParseException {
        throw new RDFParseException(builder.toString());
    }

    protected int next() throws IOException {
        int c = this.read();
        while (this.isWhitespace(c)) {
            c = this.read();
        }
        return c;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        InputStreamReader reader = new InputStreamReader(in);
        this.parse(reader, baseURI);
    }

    protected void initParse(Reader reader, String baseURI) {
        if (this.reader != reader) {
            this.reader = new PushbackReader(reader, 20);
        }
        this.baseURI = baseURI;
    }

    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        this.initParse(reader, baseURI);
        this.turtleDoc();
    }

    protected int read() throws IOException {
        if (this.reader == null) {
            return -1;
        }
        int next = this.reader.read();
        if (next == -1) {
            this.reader = null;
            return -1;
        }
        ++this.columnNumber;
        if (Character.isHighSurrogate((char)next)) {
            next = Character.toCodePoint((char)next, (char)this.reader.read());
            ++this.columnNumber;
        }
        if (next == 10) {
            ++this.lineNumber;
            this.columnNumber = 0;
        }
        return next;
    }

    protected void unread(int codePoint) throws IOException {
        if (codePoint != -1) {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogatePair = Character.toChars(codePoint);
                this.reader.unread(surrogatePair);
                this.columnNumber -= 2;
            } else {
                if (codePoint == 10) {
                    --this.lineNumber;
                    this.columnNumber = Integer.MIN_VALUE;
                } else {
                    --this.columnNumber;
                }
                if (this.reader == null) {
                    this.reader = new PushbackReader(new StringReader(""), 20);
                }
                this.reader.unread(codePoint);
            }
        }
    }

    protected boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    protected boolean tryWhitespace() throws IOException {
        int c = this.read();
        if (this.isWhitespace(c)) {
            this.skipSpace();
            return true;
        }
        this.unread(c);
        return false;
    }

    protected String tryCaseInsensitiveWord(String text) throws IOException {
        StringBuilder buffer = this.buffer();
        String upper = text.toUpperCase();
        for (int i = 0; i < upper.length(); ++i) {
            char c = upper.charAt(i);
            int k = this.read();
            char cc = Character.toUpperCase((char)k);
            buffer.append((char)k);
            if (cc == c) continue;
            this.unread(k);
            for (int j = i - 1; j >= 0; --j) {
                this.unread(buffer.charAt(j));
            }
            return null;
        }
        int next = this.read();
        this.unread(next);
        if (next > 0 && Character.isAlphabetic(next)) {
            for (int j = text.length(); j >= 0; --j) {
                this.unread(buffer.charAt(j));
            }
            return null;
        }
        return buffer.toString();
    }

    protected boolean tryWord(String text) throws IOException {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            int k = this.read();
            if (k == c) continue;
            this.unread(k);
            for (int j = i - 1; j >= 0; --j) {
                this.unread(text.charAt(j));
            }
            return false;
        }
        return true;
    }

    protected void read(char c) throws IOException, RDFParseException {
        int k = this.next();
        this.assertEquals(c, k);
    }

    protected int peek() throws IOException {
        int c = this.read();
        this.unread(c);
        return c;
    }
}

